package com.xforceplus.ultraman.app.matchingassets.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单号来源
 * </p>
 *
 * @author ultraman
 * @since 2022-08-10
 */
public enum BusinessOrderOrigin {

    _1("1", "协同"),
    _2("2", "扫描"),
    _3("3", "验真"),
    _4("4", "接口");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessOrderOrigin(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessOrderOrigin fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
