package com.xforceplus.ultraman.app.matchingassets.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 配单业务单明细子对象
 * </p>
 *
 * @author ultraman
 * @since 2022-08-10
 */
public enum MatchingBillItemSonType {

    INVOICE_NOTICE_BILL_ITEM("invoiceNoticeBillItem", "开票通知单明细");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchingBillItemSonType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchingBillItemSonType fromCode(String code){
        switch(code) {
            case "invoiceNoticeBillItem":
                return INVOICE_NOTICE_BILL_ITEM;
            default:
                return null;
        }
    }
}
