package com.xforceplus.ultraman.app.matchingassets.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 配单业务单据子对象
 * </p>
 *
 * @author ultraman
 * @since 2022-08-10
 */
public enum MatchingBillSonType {

    INVOICE_NOTICE_BILL("invoiceNoticeBill", "开票通知单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchingBillSonType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchingBillSonType fromCode(String code){
        switch(code) {
            case "invoiceNoticeBill":
                return INVOICE_NOTICE_BILL;
            default:
                return null;
        }
    }
}
