package com.xforceplus.ultraman.app.matchingassets.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2022-08-10
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1553559672084414466L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface MatchingBill {
        static Long id() {
            return 1553561627045314561L;
        }
        static String code() {
            return "matchingBill";
        }
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "installmentNum");
        TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceRemark");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> NODE = new TypedField<>(String.class, "node");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchasingTeam");
        TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchasingOrg");
        TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "buyerInvoiceTitle");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "allocationOrderStatus");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "sellerBankNo");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "sellerTelephone");
        TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "receiveEmail");
        TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "receiveTelephone");
        TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "purchaseAddress");
        TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "purchaseTelephone");
        TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "purchaseBankNo");
        TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "purchaseBankName");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashierName");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicerName");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "redNotificationNo");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "poTotalAmountWithTax");
        TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "recommendationInvoiceId");
        TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "recommendationInvoiceNo");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "negativePaymentNo");
        TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "changeTicketType");
        TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "distributeOrderInvoiceAmount");
        TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paidAmount");
        TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "businessAmount");
        TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "totalAmount");
        TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "totalAmountWithTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "hippedQuantity");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> MATCHING_BILL_SON_TYPE = new TypedField<>(String.class, "matchingBillSonType");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface MatchingBillItem {
        static Long id() {
            return 1553562178692759554L;
        }
        static String code() {
            return "matchingBillItem";
        }
        TypedField<String> ITEM_N_O = new TypedField<>(String.class, "itemNO");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> BILL_N_O = new TypedField<>(String.class, "billNO");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> WBS = new TypedField<>(String.class, "wbs");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> VIEW_ID = new TypedField<>(String.class, "viewId");
        TypedField<String> PM_NODE = new TypedField<>(String.class, "pmNode");
        TypedField<String> PRE_NO = new TypedField<>(String.class, "preNo");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> TOTAL_PAY_QTY = new TypedField<>(BigDecimal.class, "totalPayQty");
        TypedField<BigDecimal> TOTAL_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "totalPayAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> MATCHING_BILL_ITEM_SON_TYPE = new TypedField<>(String.class, "matchingBillItemSonType");
        /**
         * 对一关联关系 关联对象 matchingBill
         */
        TypedField<Long> MATCHING_BILL_PK_ID = new TypedField<>(Long.class, "matchingBillPk.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MATCHING_BILL_PK {
                static String code () {
                    return "matchingBillPk" ;
                }
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "matchingBillPk.businessType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "matchingBillPk.buyerID");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "matchingBillPk.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "matchingBillPk.buyerName");
                TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "matchingBillPk.installmentNum");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "matchingBillPk.invoiceRemark");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "matchingBillPk.priceMethod");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "matchingBillPk.currency");
                TypedField<String> NODE = new TypedField<>(String.class, "matchingBillPk.node");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "matchingBillPk.sellerTaxNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "matchingBillPk.status");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "matchingBillPk.sellerNo");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "matchingBillPk.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "matchingBillPk.purchasingOrg");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "matchingBillPk.buyerInvoiceTitle");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "matchingBillPk.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "matchingBillPk.purchaserName");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "matchingBillPk.purchaserNo");
                TypedField<String> TYPE = new TypedField<>(String.class, "matchingBillPk.type");
                TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "matchingBillPk.allocationOrderStatus");
                TypedField<String> REMARK = new TypedField<>(String.class, "matchingBillPk.remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "matchingBillPk.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "matchingBillPk.originInvoiceCode");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "matchingBillPk.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "matchingBillPk.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "matchingBillPk.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "matchingBillPk.sellerTelephone");
                TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "matchingBillPk.receiveEmail");
                TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "matchingBillPk.receiveTelephone");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "matchingBillPk.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "matchingBillPk.purchaseTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "matchingBillPk.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "matchingBillPk.purchaseBankName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "matchingBillPk.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "matchingBillPk.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "matchingBillPk.invoicerName");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "matchingBillPk.redNotificationNo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "matchingBillPk.profitCenter");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "matchingBillPk.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "matchingBillPk.invoiceCode");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "matchingBillPk.projectName");
                TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "matchingBillPk.poTotalAmountWithTax");
                TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "matchingBillPk.recommendationInvoiceId");
                TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "matchingBillPk.recommendationInvoiceNo");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "matchingBillPk.orderType");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "matchingBillPk.negativePaymentNo");
                TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "matchingBillPk.changeTicketType");
                TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillPk.distributeOrderInvoiceAmount");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillPk.paidAmount");
                TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillPk.businessAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillPk.totalAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "matchingBillPk.totalAmountWithTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillPk.taxAmount");
                TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "matchingBillPk.hippedQuantity");
                TypedField<Long> ID = new TypedField<>(Long.class, "matchingBillPk.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "matchingBillPk.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "matchingBillPk.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "matchingBillPk.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchingBillPk.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "matchingBillPk.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "matchingBillPk.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "matchingBillPk.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "matchingBillPk.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "matchingBillPk.delete_flag");
                TypedField<String> MATCHING_BILL_SON_TYPE = new TypedField<>(String.class, "matchingBillPk.matchingBillSonType");
            }
        }
    }
    public interface BillDocument {
        static Long id() {
            return 1553562406015647746L;
        }
        static String code() {
            return "billDocument";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceUrl");
        TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "paperDrawDate");
        TypedField<LocalDateTime> SEND_DATE = new TypedField<>(LocalDateTime.class, "sendDate");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "submitDate");
        TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "postingDate");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "paymentDate");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "expressNumber");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<BigDecimal> APPLY_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "applyPayAmount");
        TypedField<String> VOUCHER_NO = new TypedField<>(String.class, "voucherNo");
        TypedField<String> VOUCHER_TEXT = new TypedField<>(String.class, "voucherText");
        TypedField<LocalDateTime> PAY_BASE_DAY = new TypedField<>(LocalDateTime.class, "payBaseDay");
        TypedField<LocalDateTime> ACTUAL_PAY_DAY = new TypedField<>(LocalDateTime.class, "actualPayDay");
        TypedField<LocalDateTime> AUTH_DATE = new TypedField<>(LocalDateTime.class, "authDate");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "paymentNo");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
        TypedField<String> ACCOUNT_STATUS = new TypedField<>(String.class, "accountStatus");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "payStatus");
        TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paidAmount");
        TypedField<BigDecimal> INVOICE_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "invoicePayAmount");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "sellerAddrTel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerTel");
        TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "sellerBankNo");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaserAddrTel");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaserAddress");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaserTel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaserBankName");
        TypedField<String> PURCHASER_BANK_NO = new TypedField<>(String.class, "purchaserBankNo");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicerName");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "redNotificationNo");
        TypedField<LocalDateTime> TAX_DECLARATION_PERIOD = new TypedField<>(LocalDateTime.class, "taxDeclarationPeriod");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scanTime");
        TypedField<String> SCAN_DEDUCTION_IMAGE_URL = new TypedField<>(String.class, "scanDeductionImageUrl");
        TypedField<String> SCAN_INVOICE_IMAGE_URL = new TypedField<>(String.class, "scanInvoiceImageUrl");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "authStatus");
        TypedField<String> TAX_FLAG = new TypedField<>(String.class, "taxFlag");
        TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "scanStatus");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<String> INVOICE_NOTICE_NOS = new TypedField<>(String.class, "invoiceNoticeNos");
        TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceId");
        TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchasingTeam");
        TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "sendCount");
        TypedField<Long> BACK_COUNT = new TypedField<>(Long.class, "backCount");
        TypedField<Boolean> RECOMMENDATION_FLAG = new TypedField<>(Boolean.class, "recommendationFlag");
        TypedField<BigDecimal> MATCHED_AMOUNT = new TypedField<>(BigDecimal.class, "matchedAmount");
        TypedField<LocalDateTime> ACCOUNT_DATE = new TypedField<>(LocalDateTime.class, "account_date");
        TypedField<Long> RELATION_COUNT = new TypedField<>(Long.class, "relationCount");
        TypedField<String> LAST_SOURCE = new TypedField<>(String.class, "lastSource");
        TypedField<String> ORIGIN_FILE = new TypedField<>(String.class, "originFile");
        TypedField<String> ORIGIN_FILE_URL = new TypedField<>(String.class, "originFileUrl");
        TypedField<String> RETURN_REASON = new TypedField<>(String.class, "returnReason");
        TypedField<BigDecimal> AVAILABLE_AMOUNT = new TypedField<>(BigDecimal.class, "availableAmount");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILL_DOCUMENT_SON_TYPE = new TypedField<>(String.class, "billDocumentSonType");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface BillDocumentItem {
        static Long id() {
            return 1553562681992462338L;
        }
        static String code() {
            return "billDocumentItem";
        }
        TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceId");
        TypedField<String> PRE_INVOICE_ID = new TypedField<>(String.class, "preInvoiceId");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<String> SALESBILL_ITEM_NO = new TypedField<>(String.class, "salesbillItemNo");
        TypedField<String> PRE_INVOICE_ITEM_ID = new TypedField<>(String.class, "preInvoiceItemId");
        TypedField<String> SALESBILL_ITEM_ID = new TypedField<>(String.class, "salesbillItemId");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> CARGO_CODE = new TypedField<>(String.class, "cargoCode");
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargoName");
        TypedField<String> ITEM_CODE = new TypedField<>(String.class, "itemCode");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<String> GOODS_NO_VER = new TypedField<>(String.class, "goodsNoVer");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<String> DISCOUNT_FLAG = new TypedField<>(String.class, "discountFlag");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<String> PRINT_CONTENT_FLAG = new TypedField<>(String.class, "printContentFlag");
        TypedField<String> INVOICE_ITEM_ID = new TypedField<>(String.class, "invoiceItemId");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> DEDUCTION = new TypedField<>(BigDecimal.class, "deduction");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILL_DOCUMENT_ITEM_SON_TYPE = new TypedField<>(String.class, "billDocumentItemSonType");
        /**
         * 对一关联关系 关联对象 billDocument
         */
        TypedField<Long> BILL_DOCUMENT_PK_ID = new TypedField<>(Long.class, "billDocumentPk.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DOCUMENT_PK {
                static String code () {
                    return "billDocumentPk" ;
                }
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "billDocumentPk.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "billDocumentPk.invoiceNo");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "billDocumentPk.invoiceType");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "billDocumentPk.invoiceStatus");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "billDocumentPk.invoiceUrl");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "billDocumentPk.paperDrawDate");
                TypedField<LocalDateTime> SEND_DATE = new TypedField<>(LocalDateTime.class, "billDocumentPk.sendDate");
                TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "billDocumentPk.receiptDate");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "billDocumentPk.submitDate");
                TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "billDocumentPk.postingDate");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "billDocumentPk.paymentDate");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billDocumentPk.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "billDocumentPk.buyerName");
                TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "billDocumentPk.expressNumber");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentPk.taxAmount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billDocumentPk.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billDocumentPk.amountWithoutTax");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "billDocumentPk.sellerNo");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "billDocumentPk.buyerID");
                TypedField<BigDecimal> APPLY_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentPk.applyPayAmount");
                TypedField<String> VOUCHER_NO = new TypedField<>(String.class, "billDocumentPk.voucherNo");
                TypedField<String> VOUCHER_TEXT = new TypedField<>(String.class, "billDocumentPk.voucherText");
                TypedField<LocalDateTime> PAY_BASE_DAY = new TypedField<>(LocalDateTime.class, "billDocumentPk.payBaseDay");
                TypedField<LocalDateTime> ACTUAL_PAY_DAY = new TypedField<>(LocalDateTime.class, "billDocumentPk.actualPayDay");
                TypedField<LocalDateTime> AUTH_DATE = new TypedField<>(LocalDateTime.class, "billDocumentPk.authDate");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "billDocumentPk.paymentNo");
                TypedField<String> PO_NO = new TypedField<>(String.class, "billDocumentPk.poNo");
                TypedField<String> ACCOUNT_STATUS = new TypedField<>(String.class, "billDocumentPk.accountStatus");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billDocumentPk.payStatus");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentPk.paidAmount");
                TypedField<BigDecimal> INVOICE_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentPk.invoicePayAmount");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billDocumentPk.sellerTaxNo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "billDocumentPk.sellerAddrTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "billDocumentPk.sellerAddress");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "billDocumentPk.sellerTel");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "billDocumentPk.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "billDocumentPk.sellerBankName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billDocumentPk.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billDocumentPk.purchaserName");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "billDocumentPk.purchaserAddrTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "billDocumentPk.purchaserAddress");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "billDocumentPk.purchaserTel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "billDocumentPk.purchaserBankName");
                TypedField<String> PURCHASER_BANK_NO = new TypedField<>(String.class, "billDocumentPk.purchaserBankNo");
                TypedField<String> REMARK = new TypedField<>(String.class, "billDocumentPk.remark");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "billDocumentPk.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "billDocumentPk.invoicerName");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "billDocumentPk.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "billDocumentPk.originInvoiceCode");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "billDocumentPk.redNotificationNo");
                TypedField<LocalDateTime> TAX_DECLARATION_PERIOD = new TypedField<>(LocalDateTime.class, "billDocumentPk.taxDeclarationPeriod");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "billDocumentPk.scanTime");
                TypedField<String> SCAN_DEDUCTION_IMAGE_URL = new TypedField<>(String.class, "billDocumentPk.scanDeductionImageUrl");
                TypedField<String> SCAN_INVOICE_IMAGE_URL = new TypedField<>(String.class, "billDocumentPk.scanInvoiceImageUrl");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billDocumentPk.purchaserNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "billDocumentPk.status");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "billDocumentPk.authStatus");
                TypedField<String> TAX_FLAG = new TypedField<>(String.class, "billDocumentPk.taxFlag");
                TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "billDocumentPk.scanStatus");
                TypedField<String> SOURCE = new TypedField<>(String.class, "billDocumentPk.source");
                TypedField<String> INVOICE_NOTICE_NOS = new TypedField<>(String.class, "billDocumentPk.invoiceNoticeNos");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "billDocumentPk.invoiceId");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "billDocumentPk.purchasingTeam");
                TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "billDocumentPk.sendCount");
                TypedField<Long> BACK_COUNT = new TypedField<>(Long.class, "billDocumentPk.backCount");
                TypedField<Boolean> RECOMMENDATION_FLAG = new TypedField<>(Boolean.class, "billDocumentPk.recommendationFlag");
                TypedField<BigDecimal> MATCHED_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentPk.matchedAmount");
                TypedField<LocalDateTime> ACCOUNT_DATE = new TypedField<>(LocalDateTime.class, "billDocumentPk.account_date");
                TypedField<Long> RELATION_COUNT = new TypedField<>(Long.class, "billDocumentPk.relationCount");
                TypedField<String> LAST_SOURCE = new TypedField<>(String.class, "billDocumentPk.lastSource");
                TypedField<String> ORIGIN_FILE = new TypedField<>(String.class, "billDocumentPk.originFile");
                TypedField<String> ORIGIN_FILE_URL = new TypedField<>(String.class, "billDocumentPk.originFileUrl");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "billDocumentPk.returnReason");
                TypedField<BigDecimal> AVAILABLE_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentPk.availableAmount");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "billDocumentPk.serialNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDocumentPk.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDocumentPk.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDocumentPk.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDocumentPk.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDocumentPk.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDocumentPk.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDocumentPk.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDocumentPk.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDocumentPk.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDocumentPk.delete_flag");
                TypedField<String> BILL_DOCUMENT_SON_TYPE = new TypedField<>(String.class, "billDocumentPk.billDocumentSonType");
            }
        }
    }
    public interface MatchingRule {
        static Long id() {
            return 1553568435528974337L;
        }
        static String code() {
            return "matchingRule";
        }
        TypedField<String> TEST = new TypedField<>(String.class, "test");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 matchingBill
         */
        TypedField<Long> MATCHING_BILL_RULES_ID = new TypedField<>(Long.class, "matchingBillRules.id");
        /**
         * 对一关联关系 关联对象 billDocument
         */
        TypedField<Long> BILL_DOCUMENT_RULES_ID = new TypedField<>(Long.class, "billDocumentRules.id");
        /**
         * 对一关联关系 关联对象 matchingRelation
         */
        TypedField<Long> MATCHING_RULES_ID = new TypedField<>(Long.class, "matchingRules.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MATCHING_BILL_RULES {
                static String code () {
                    return "matchingBillRules" ;
                }
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "matchingBillRules.businessType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "matchingBillRules.buyerID");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "matchingBillRules.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "matchingBillRules.buyerName");
                TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "matchingBillRules.installmentNum");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "matchingBillRules.invoiceRemark");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "matchingBillRules.priceMethod");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "matchingBillRules.currency");
                TypedField<String> NODE = new TypedField<>(String.class, "matchingBillRules.node");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "matchingBillRules.sellerTaxNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "matchingBillRules.status");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "matchingBillRules.sellerNo");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "matchingBillRules.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "matchingBillRules.purchasingOrg");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "matchingBillRules.buyerInvoiceTitle");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "matchingBillRules.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "matchingBillRules.purchaserName");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "matchingBillRules.purchaserNo");
                TypedField<String> TYPE = new TypedField<>(String.class, "matchingBillRules.type");
                TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "matchingBillRules.allocationOrderStatus");
                TypedField<String> REMARK = new TypedField<>(String.class, "matchingBillRules.remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "matchingBillRules.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "matchingBillRules.originInvoiceCode");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "matchingBillRules.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "matchingBillRules.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "matchingBillRules.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "matchingBillRules.sellerTelephone");
                TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "matchingBillRules.receiveEmail");
                TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "matchingBillRules.receiveTelephone");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "matchingBillRules.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "matchingBillRules.purchaseTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "matchingBillRules.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "matchingBillRules.purchaseBankName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "matchingBillRules.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "matchingBillRules.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "matchingBillRules.invoicerName");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "matchingBillRules.redNotificationNo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "matchingBillRules.profitCenter");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "matchingBillRules.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "matchingBillRules.invoiceCode");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "matchingBillRules.projectName");
                TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "matchingBillRules.poTotalAmountWithTax");
                TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "matchingBillRules.recommendationInvoiceId");
                TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "matchingBillRules.recommendationInvoiceNo");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "matchingBillRules.orderType");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "matchingBillRules.negativePaymentNo");
                TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "matchingBillRules.changeTicketType");
                TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillRules.distributeOrderInvoiceAmount");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillRules.paidAmount");
                TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillRules.businessAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillRules.totalAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "matchingBillRules.totalAmountWithTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillRules.taxAmount");
                TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "matchingBillRules.hippedQuantity");
                TypedField<Long> ID = new TypedField<>(Long.class, "matchingBillRules.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "matchingBillRules.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "matchingBillRules.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "matchingBillRules.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchingBillRules.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "matchingBillRules.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "matchingBillRules.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "matchingBillRules.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "matchingBillRules.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "matchingBillRules.delete_flag");
                TypedField<String> MATCHING_BILL_SON_TYPE = new TypedField<>(String.class, "matchingBillRules.matchingBillSonType");
            }
            interface BILL_DOCUMENT_RULES {
                static String code () {
                    return "billDocumentRules" ;
                }
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "billDocumentRules.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "billDocumentRules.invoiceNo");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "billDocumentRules.invoiceType");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "billDocumentRules.invoiceStatus");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "billDocumentRules.invoiceUrl");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "billDocumentRules.paperDrawDate");
                TypedField<LocalDateTime> SEND_DATE = new TypedField<>(LocalDateTime.class, "billDocumentRules.sendDate");
                TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "billDocumentRules.receiptDate");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "billDocumentRules.submitDate");
                TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "billDocumentRules.postingDate");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "billDocumentRules.paymentDate");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billDocumentRules.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "billDocumentRules.buyerName");
                TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "billDocumentRules.expressNumber");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentRules.taxAmount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billDocumentRules.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billDocumentRules.amountWithoutTax");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "billDocumentRules.sellerNo");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "billDocumentRules.buyerID");
                TypedField<BigDecimal> APPLY_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentRules.applyPayAmount");
                TypedField<String> VOUCHER_NO = new TypedField<>(String.class, "billDocumentRules.voucherNo");
                TypedField<String> VOUCHER_TEXT = new TypedField<>(String.class, "billDocumentRules.voucherText");
                TypedField<LocalDateTime> PAY_BASE_DAY = new TypedField<>(LocalDateTime.class, "billDocumentRules.payBaseDay");
                TypedField<LocalDateTime> ACTUAL_PAY_DAY = new TypedField<>(LocalDateTime.class, "billDocumentRules.actualPayDay");
                TypedField<LocalDateTime> AUTH_DATE = new TypedField<>(LocalDateTime.class, "billDocumentRules.authDate");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "billDocumentRules.paymentNo");
                TypedField<String> PO_NO = new TypedField<>(String.class, "billDocumentRules.poNo");
                TypedField<String> ACCOUNT_STATUS = new TypedField<>(String.class, "billDocumentRules.accountStatus");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billDocumentRules.payStatus");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentRules.paidAmount");
                TypedField<BigDecimal> INVOICE_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentRules.invoicePayAmount");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billDocumentRules.sellerTaxNo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "billDocumentRules.sellerAddrTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "billDocumentRules.sellerAddress");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "billDocumentRules.sellerTel");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "billDocumentRules.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "billDocumentRules.sellerBankName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billDocumentRules.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billDocumentRules.purchaserName");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "billDocumentRules.purchaserAddrTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "billDocumentRules.purchaserAddress");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "billDocumentRules.purchaserTel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "billDocumentRules.purchaserBankName");
                TypedField<String> PURCHASER_BANK_NO = new TypedField<>(String.class, "billDocumentRules.purchaserBankNo");
                TypedField<String> REMARK = new TypedField<>(String.class, "billDocumentRules.remark");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "billDocumentRules.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "billDocumentRules.invoicerName");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "billDocumentRules.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "billDocumentRules.originInvoiceCode");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "billDocumentRules.redNotificationNo");
                TypedField<LocalDateTime> TAX_DECLARATION_PERIOD = new TypedField<>(LocalDateTime.class, "billDocumentRules.taxDeclarationPeriod");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "billDocumentRules.scanTime");
                TypedField<String> SCAN_DEDUCTION_IMAGE_URL = new TypedField<>(String.class, "billDocumentRules.scanDeductionImageUrl");
                TypedField<String> SCAN_INVOICE_IMAGE_URL = new TypedField<>(String.class, "billDocumentRules.scanInvoiceImageUrl");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billDocumentRules.purchaserNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "billDocumentRules.status");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "billDocumentRules.authStatus");
                TypedField<String> TAX_FLAG = new TypedField<>(String.class, "billDocumentRules.taxFlag");
                TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "billDocumentRules.scanStatus");
                TypedField<String> SOURCE = new TypedField<>(String.class, "billDocumentRules.source");
                TypedField<String> INVOICE_NOTICE_NOS = new TypedField<>(String.class, "billDocumentRules.invoiceNoticeNos");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "billDocumentRules.invoiceId");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "billDocumentRules.purchasingTeam");
                TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "billDocumentRules.sendCount");
                TypedField<Long> BACK_COUNT = new TypedField<>(Long.class, "billDocumentRules.backCount");
                TypedField<Boolean> RECOMMENDATION_FLAG = new TypedField<>(Boolean.class, "billDocumentRules.recommendationFlag");
                TypedField<BigDecimal> MATCHED_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentRules.matchedAmount");
                TypedField<LocalDateTime> ACCOUNT_DATE = new TypedField<>(LocalDateTime.class, "billDocumentRules.account_date");
                TypedField<Long> RELATION_COUNT = new TypedField<>(Long.class, "billDocumentRules.relationCount");
                TypedField<String> LAST_SOURCE = new TypedField<>(String.class, "billDocumentRules.lastSource");
                TypedField<String> ORIGIN_FILE = new TypedField<>(String.class, "billDocumentRules.originFile");
                TypedField<String> ORIGIN_FILE_URL = new TypedField<>(String.class, "billDocumentRules.originFileUrl");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "billDocumentRules.returnReason");
                TypedField<BigDecimal> AVAILABLE_AMOUNT = new TypedField<>(BigDecimal.class, "billDocumentRules.availableAmount");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "billDocumentRules.serialNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDocumentRules.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDocumentRules.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDocumentRules.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDocumentRules.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDocumentRules.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDocumentRules.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDocumentRules.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDocumentRules.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDocumentRules.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDocumentRules.delete_flag");
                TypedField<String> BILL_DOCUMENT_SON_TYPE = new TypedField<>(String.class, "billDocumentRules.billDocumentSonType");
            }
            interface MATCHING_RULES {
                static String code () {
                    return "matchingRules" ;
                }
                TypedField<String> BILL_NO = new TypedField<>(String.class, "matchingRules.billNo");
                TypedField<String> BILL_ORIGIN = new TypedField<>(String.class, "matchingRules.billOrigin");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchingRules.matchStatus");
                TypedField<String> MATCH_USER_NAME = new TypedField<>(String.class, "matchingRules.matchUserName");
                TypedField<Long> MATCH_USER_ID = new TypedField<>(Long.class, "matchingRules.matchUserId");
                TypedField<BigDecimal> MATCH_AMOUNT = new TypedField<>(BigDecimal.class, "matchingRules.matchAmount");
                TypedField<LocalDateTime> MATCH_TIME = new TypedField<>(LocalDateTime.class, "matchingRules.matchTime");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "matchingRules.dataStatus");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "matchingRules.orgId");
                TypedField<Long> BILL_ID = new TypedField<>(Long.class, "matchingRules.billId");
                TypedField<Long> ID = new TypedField<>(Long.class, "matchingRules.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "matchingRules.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "matchingRules.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "matchingRules.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchingRules.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "matchingRules.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "matchingRules.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "matchingRules.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "matchingRules.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "matchingRules.delete_flag");
                TypedField<String> BILL_DOC_ID = new TypedField<>(String.class, "matchingRules.billDocId");
                TypedField<String> BILL_DOC_NO = new TypedField<>(String.class, "matchingRules.billDocNo");
                TypedField<String> INVOICE_REGISTER_STATUS_CP = new TypedField<>(String.class, "matchingRules.invoiceRegisterStatusCp");
            }
        }
    }
    public interface MatchingRelation {
        static Long id() {
            return 1556465328474996738L;
        }
        static String code() {
            return "matchingRelation";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> BILL_ORIGIN = new TypedField<>(String.class, "billOrigin");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchStatus");
        TypedField<String> MATCH_USER_NAME = new TypedField<>(String.class, "matchUserName");
        TypedField<Long> MATCH_USER_ID = new TypedField<>(Long.class, "matchUserId");
        TypedField<BigDecimal> MATCH_AMOUNT = new TypedField<>(BigDecimal.class, "matchAmount");
        TypedField<LocalDateTime> MATCH_TIME = new TypedField<>(LocalDateTime.class, "matchTime");
        TypedField<String> DATA_STATUS = new TypedField<>(String.class, "dataStatus");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "orgId");
        TypedField<Long> BILL_ID = new TypedField<>(Long.class, "billId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILL_DOC_ID = new TypedField<>(String.class, "billDocId");
        TypedField<String> BILL_DOC_NO = new TypedField<>(String.class, "billDocNo");
        TypedField<String> INVOICE_REGISTER_STATUS_CP = new TypedField<>(String.class, "invoiceRegisterStatusCp");
        /**
         * 对一关联关系 关联对象 matchingBill
         */
        TypedField<Long> BILL_TO_DOC_ID = new TypedField<>(Long.class, "billToDoc.id");
        /**
         * 对一关联关系 关联对象 billDocument
         */
        TypedField<Long> DOC_TO_BILL_ID = new TypedField<>(Long.class, "docToBill.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_TO_DOC {
                static String code () {
                    return "billToDoc" ;
                }
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billToDoc.businessType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "billToDoc.buyerID");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billToDoc.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "billToDoc.buyerName");
                TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "billToDoc.installmentNum");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "billToDoc.invoiceRemark");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "billToDoc.priceMethod");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "billToDoc.currency");
                TypedField<String> NODE = new TypedField<>(String.class, "billToDoc.node");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billToDoc.sellerTaxNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "billToDoc.status");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "billToDoc.sellerNo");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "billToDoc.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "billToDoc.purchasingOrg");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "billToDoc.buyerInvoiceTitle");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billToDoc.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billToDoc.purchaserName");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billToDoc.purchaserNo");
                TypedField<String> TYPE = new TypedField<>(String.class, "billToDoc.type");
                TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "billToDoc.allocationOrderStatus");
                TypedField<String> REMARK = new TypedField<>(String.class, "billToDoc.remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "billToDoc.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "billToDoc.originInvoiceCode");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "billToDoc.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "billToDoc.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "billToDoc.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "billToDoc.sellerTelephone");
                TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "billToDoc.receiveEmail");
                TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "billToDoc.receiveTelephone");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "billToDoc.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "billToDoc.purchaseTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "billToDoc.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "billToDoc.purchaseBankName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "billToDoc.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "billToDoc.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "billToDoc.invoicerName");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "billToDoc.redNotificationNo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "billToDoc.profitCenter");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "billToDoc.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "billToDoc.invoiceCode");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "billToDoc.projectName");
                TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billToDoc.poTotalAmountWithTax");
                TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "billToDoc.recommendationInvoiceId");
                TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "billToDoc.recommendationInvoiceNo");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "billToDoc.orderType");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "billToDoc.negativePaymentNo");
                TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "billToDoc.changeTicketType");
                TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "billToDoc.distributeOrderInvoiceAmount");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "billToDoc.paidAmount");
                TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "billToDoc.businessAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "billToDoc.totalAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billToDoc.totalAmountWithTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billToDoc.taxAmount");
                TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "billToDoc.hippedQuantity");
                TypedField<Long> ID = new TypedField<>(Long.class, "billToDoc.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billToDoc.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billToDoc.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billToDoc.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billToDoc.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billToDoc.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billToDoc.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billToDoc.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billToDoc.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billToDoc.delete_flag");
                TypedField<String> MATCHING_BILL_SON_TYPE = new TypedField<>(String.class, "billToDoc.matchingBillSonType");
            }
            interface DOC_TO_BILL {
                static String code () {
                    return "docToBill" ;
                }
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "docToBill.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "docToBill.invoiceNo");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "docToBill.invoiceType");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "docToBill.invoiceStatus");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "docToBill.invoiceUrl");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "docToBill.paperDrawDate");
                TypedField<LocalDateTime> SEND_DATE = new TypedField<>(LocalDateTime.class, "docToBill.sendDate");
                TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "docToBill.receiptDate");
                TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "docToBill.submitDate");
                TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "docToBill.postingDate");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "docToBill.paymentDate");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "docToBill.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "docToBill.buyerName");
                TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "docToBill.expressNumber");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "docToBill.taxAmount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "docToBill.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "docToBill.amountWithoutTax");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "docToBill.sellerNo");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "docToBill.buyerID");
                TypedField<BigDecimal> APPLY_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "docToBill.applyPayAmount");
                TypedField<String> VOUCHER_NO = new TypedField<>(String.class, "docToBill.voucherNo");
                TypedField<String> VOUCHER_TEXT = new TypedField<>(String.class, "docToBill.voucherText");
                TypedField<LocalDateTime> PAY_BASE_DAY = new TypedField<>(LocalDateTime.class, "docToBill.payBaseDay");
                TypedField<LocalDateTime> ACTUAL_PAY_DAY = new TypedField<>(LocalDateTime.class, "docToBill.actualPayDay");
                TypedField<LocalDateTime> AUTH_DATE = new TypedField<>(LocalDateTime.class, "docToBill.authDate");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "docToBill.paymentNo");
                TypedField<String> PO_NO = new TypedField<>(String.class, "docToBill.poNo");
                TypedField<String> ACCOUNT_STATUS = new TypedField<>(String.class, "docToBill.accountStatus");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "docToBill.payStatus");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "docToBill.paidAmount");
                TypedField<BigDecimal> INVOICE_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "docToBill.invoicePayAmount");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "docToBill.sellerTaxNo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "docToBill.sellerAddrTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "docToBill.sellerAddress");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "docToBill.sellerTel");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "docToBill.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "docToBill.sellerBankName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "docToBill.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "docToBill.purchaserName");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "docToBill.purchaserAddrTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "docToBill.purchaserAddress");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "docToBill.purchaserTel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "docToBill.purchaserBankName");
                TypedField<String> PURCHASER_BANK_NO = new TypedField<>(String.class, "docToBill.purchaserBankNo");
                TypedField<String> REMARK = new TypedField<>(String.class, "docToBill.remark");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "docToBill.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "docToBill.invoicerName");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "docToBill.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "docToBill.originInvoiceCode");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "docToBill.redNotificationNo");
                TypedField<LocalDateTime> TAX_DECLARATION_PERIOD = new TypedField<>(LocalDateTime.class, "docToBill.taxDeclarationPeriod");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "docToBill.scanTime");
                TypedField<String> SCAN_DEDUCTION_IMAGE_URL = new TypedField<>(String.class, "docToBill.scanDeductionImageUrl");
                TypedField<String> SCAN_INVOICE_IMAGE_URL = new TypedField<>(String.class, "docToBill.scanInvoiceImageUrl");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "docToBill.purchaserNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "docToBill.status");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "docToBill.authStatus");
                TypedField<String> TAX_FLAG = new TypedField<>(String.class, "docToBill.taxFlag");
                TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "docToBill.scanStatus");
                TypedField<String> SOURCE = new TypedField<>(String.class, "docToBill.source");
                TypedField<String> INVOICE_NOTICE_NOS = new TypedField<>(String.class, "docToBill.invoiceNoticeNos");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "docToBill.invoiceId");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "docToBill.purchasingTeam");
                TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "docToBill.sendCount");
                TypedField<Long> BACK_COUNT = new TypedField<>(Long.class, "docToBill.backCount");
                TypedField<Boolean> RECOMMENDATION_FLAG = new TypedField<>(Boolean.class, "docToBill.recommendationFlag");
                TypedField<BigDecimal> MATCHED_AMOUNT = new TypedField<>(BigDecimal.class, "docToBill.matchedAmount");
                TypedField<LocalDateTime> ACCOUNT_DATE = new TypedField<>(LocalDateTime.class, "docToBill.account_date");
                TypedField<Long> RELATION_COUNT = new TypedField<>(Long.class, "docToBill.relationCount");
                TypedField<String> LAST_SOURCE = new TypedField<>(String.class, "docToBill.lastSource");
                TypedField<String> ORIGIN_FILE = new TypedField<>(String.class, "docToBill.originFile");
                TypedField<String> ORIGIN_FILE_URL = new TypedField<>(String.class, "docToBill.originFileUrl");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "docToBill.returnReason");
                TypedField<BigDecimal> AVAILABLE_AMOUNT = new TypedField<>(BigDecimal.class, "docToBill.availableAmount");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "docToBill.serialNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "docToBill.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "docToBill.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "docToBill.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "docToBill.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "docToBill.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "docToBill.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "docToBill.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "docToBill.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "docToBill.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "docToBill.delete_flag");
                TypedField<String> BILL_DOCUMENT_SON_TYPE = new TypedField<>(String.class, "docToBill.billDocumentSonType");
            }
        }
    }
    public interface InvoiceNoticeBill {
        static Long id() {
            return 1556921639020969985L;
        }
        static String code() {
            return "invoiceNoticeBill";
        }
        TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeNO");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "installmentNum");
        TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceRemark");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> NODE = new TypedField<>(String.class, "node");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchasingTeam");
        TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchasingOrg");
        TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "buyerInvoiceTitle");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "allocationOrderStatus");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "sellerBankNo");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "sellerTelephone");
        TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "receiveEmail");
        TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "receiveTelephone");
        TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "purchaseAddress");
        TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "purchaseTelephone");
        TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "purchaseBankNo");
        TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "purchaseBankName");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashierName");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicerName");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "redNotificationNo");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "poTotalAmountWithTax");
        TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "recommendationInvoiceId");
        TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "recommendationInvoiceNo");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "negativePaymentNo");
        TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "changeTicketType");
        TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "distributeOrderInvoiceAmount");
        TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paidAmount");
        TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "businessAmount");
        TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "totalAmount");
        TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "totalAmountWithTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "hippedQuantity");
        TypedField<String> MATCHING_BILL_SON_TYPE = new TypedField<>(String.class, "matchingBillSonType");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface InvoiceNoticeBillItem {
        static Long id() {
            return 1556921972403273730L;
        }
        static String code() {
            return "invoiceNoticeBillItem";
        }
        TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeNO");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ITEM_N_O = new TypedField<>(String.class, "itemNO");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> BILL_N_O = new TypedField<>(String.class, "billNO");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> WBS = new TypedField<>(String.class, "wbs");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> VIEW_ID = new TypedField<>(String.class, "viewId");
        TypedField<String> PM_NODE = new TypedField<>(String.class, "pmNode");
        TypedField<String> PRE_NO = new TypedField<>(String.class, "preNo");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> TOTAL_PAY_QTY = new TypedField<>(BigDecimal.class, "totalPayQty");
        TypedField<BigDecimal> TOTAL_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "totalPayAmount");
        TypedField<String> MATCHING_BILL_ITEM_SON_TYPE = new TypedField<>(String.class, "matchingBillItemSonType");
        /**
         * 对一关联关系 关联对象 matchingBill
         */
        TypedField<Long> MATCHING_BILL_PK_ID = new TypedField<>(Long.class, "matchingBillPk.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MATCHING_BILL_PK {
                static String code () {
                    return "matchingBillPk" ;
                }
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "matchingBillPk.businessType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "matchingBillPk.buyerID");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "matchingBillPk.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "matchingBillPk.buyerName");
                TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "matchingBillPk.installmentNum");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "matchingBillPk.invoiceRemark");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "matchingBillPk.priceMethod");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "matchingBillPk.currency");
                TypedField<String> NODE = new TypedField<>(String.class, "matchingBillPk.node");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "matchingBillPk.sellerTaxNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "matchingBillPk.status");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "matchingBillPk.sellerNo");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "matchingBillPk.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "matchingBillPk.purchasingOrg");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "matchingBillPk.buyerInvoiceTitle");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "matchingBillPk.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "matchingBillPk.purchaserName");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "matchingBillPk.purchaserNo");
                TypedField<String> TYPE = new TypedField<>(String.class, "matchingBillPk.type");
                TypedField<String> ALLOCATION_ORDER_STATUS = new TypedField<>(String.class, "matchingBillPk.allocationOrderStatus");
                TypedField<String> REMARK = new TypedField<>(String.class, "matchingBillPk.remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "matchingBillPk.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "matchingBillPk.originInvoiceCode");
                TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "matchingBillPk.sellerBankNo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "matchingBillPk.sellerBankName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "matchingBillPk.sellerAddress");
                TypedField<String> SELLER_TELEPHONE = new TypedField<>(String.class, "matchingBillPk.sellerTelephone");
                TypedField<String> RECEIVE_EMAIL = new TypedField<>(String.class, "matchingBillPk.receiveEmail");
                TypedField<String> RECEIVE_TELEPHONE = new TypedField<>(String.class, "matchingBillPk.receiveTelephone");
                TypedField<String> PURCHASE_ADDRESS = new TypedField<>(String.class, "matchingBillPk.purchaseAddress");
                TypedField<String> PURCHASE_TELEPHONE = new TypedField<>(String.class, "matchingBillPk.purchaseTelephone");
                TypedField<String> PURCHASE_BANK_NO = new TypedField<>(String.class, "matchingBillPk.purchaseBankNo");
                TypedField<String> PURCHASE_BANK_NAME = new TypedField<>(String.class, "matchingBillPk.purchaseBankName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "matchingBillPk.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "matchingBillPk.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "matchingBillPk.invoicerName");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "matchingBillPk.redNotificationNo");
                TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "matchingBillPk.profitCenter");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "matchingBillPk.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "matchingBillPk.invoiceCode");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "matchingBillPk.projectName");
                TypedField<BigDecimal> PO_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "matchingBillPk.poTotalAmountWithTax");
                TypedField<String> RECOMMENDATION_INVOICE_ID = new TypedField<>(String.class, "matchingBillPk.recommendationInvoiceId");
                TypedField<String> RECOMMENDATION_INVOICE_NO = new TypedField<>(String.class, "matchingBillPk.recommendationInvoiceNo");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "matchingBillPk.orderType");
                TypedField<String> NEGATIVE_PAYMENT_NO = new TypedField<>(String.class, "matchingBillPk.negativePaymentNo");
                TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "matchingBillPk.changeTicketType");
                TypedField<BigDecimal> DISTRIBUTE_ORDER_INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillPk.distributeOrderInvoiceAmount");
                TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillPk.paidAmount");
                TypedField<BigDecimal> BUSINESS_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillPk.businessAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillPk.totalAmount");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "matchingBillPk.totalAmountWithTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "matchingBillPk.taxAmount");
                TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "matchingBillPk.hippedQuantity");
                TypedField<Long> ID = new TypedField<>(Long.class, "matchingBillPk.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "matchingBillPk.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "matchingBillPk.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "matchingBillPk.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchingBillPk.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "matchingBillPk.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "matchingBillPk.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "matchingBillPk.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "matchingBillPk.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "matchingBillPk.delete_flag");
                TypedField<String> MATCHING_BILL_SON_TYPE = new TypedField<>(String.class, "matchingBillPk.matchingBillSonType");
            }
        }
    }
    public interface Invoice {
        static Long id() {
            return 1556922899736477697L;
        }
        static String code() {
            return "invoice";
        }
        TypedField<String> INVOICE_TEST_NO1 = new TypedField<>(String.class, "invoiceTestNo1");
        TypedField<String> INVOICE_TEST_NO2 = new TypedField<>(String.class, "invoiceTestNo2");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceUrl");
        TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "paperDrawDate");
        TypedField<LocalDateTime> SEND_DATE = new TypedField<>(LocalDateTime.class, "sendDate");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "submitDate");
        TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "postingDate");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "paymentDate");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "expressNumber");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<BigDecimal> APPLY_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "applyPayAmount");
        TypedField<String> VOUCHER_NO = new TypedField<>(String.class, "voucherNo");
        TypedField<String> VOUCHER_TEXT = new TypedField<>(String.class, "voucherText");
        TypedField<LocalDateTime> PAY_BASE_DAY = new TypedField<>(LocalDateTime.class, "payBaseDay");
        TypedField<LocalDateTime> ACTUAL_PAY_DAY = new TypedField<>(LocalDateTime.class, "actualPayDay");
        TypedField<LocalDateTime> AUTH_DATE = new TypedField<>(LocalDateTime.class, "authDate");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "paymentNo");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
        TypedField<String> ACCOUNT_STATUS = new TypedField<>(String.class, "accountStatus");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "payStatus");
        TypedField<BigDecimal> PAID_AMOUNT = new TypedField<>(BigDecimal.class, "paidAmount");
        TypedField<BigDecimal> INVOICE_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "invoicePayAmount");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "sellerAddrTel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerTel");
        TypedField<String> SELLER_BANK_NO = new TypedField<>(String.class, "sellerBankNo");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaserAddrTel");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaserAddress");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaserTel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaserBankName");
        TypedField<String> PURCHASER_BANK_NO = new TypedField<>(String.class, "purchaserBankNo");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicerName");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "redNotificationNo");
        TypedField<LocalDateTime> TAX_DECLARATION_PERIOD = new TypedField<>(LocalDateTime.class, "taxDeclarationPeriod");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scanTime");
        TypedField<String> SCAN_DEDUCTION_IMAGE_URL = new TypedField<>(String.class, "scanDeductionImageUrl");
        TypedField<String> SCAN_INVOICE_IMAGE_URL = new TypedField<>(String.class, "scanInvoiceImageUrl");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "authStatus");
        TypedField<String> TAX_FLAG = new TypedField<>(String.class, "taxFlag");
        TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "scanStatus");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<String> INVOICE_NOTICE_NOS = new TypedField<>(String.class, "invoiceNoticeNos");
        TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceId");
        TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchasingTeam");
        TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "sendCount");
        TypedField<Long> BACK_COUNT = new TypedField<>(Long.class, "backCount");
        TypedField<Boolean> RECOMMENDATION_FLAG = new TypedField<>(Boolean.class, "recommendationFlag");
        TypedField<BigDecimal> MATCHED_AMOUNT = new TypedField<>(BigDecimal.class, "matchedAmount");
        TypedField<LocalDateTime> ACCOUNT_DATE = new TypedField<>(LocalDateTime.class, "account_date");
        TypedField<Long> RELATION_COUNT = new TypedField<>(Long.class, "relationCount");
        TypedField<String> LAST_SOURCE = new TypedField<>(String.class, "lastSource");
        TypedField<String> ORIGIN_FILE = new TypedField<>(String.class, "originFile");
        TypedField<String> ORIGIN_FILE_URL = new TypedField<>(String.class, "originFileUrl");
        TypedField<String> RETURN_REASON = new TypedField<>(String.class, "returnReason");
        TypedField<BigDecimal> AVAILABLE_AMOUNT = new TypedField<>(BigDecimal.class, "availableAmount");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");
        TypedField<String> BILL_DOCUMENT_SON_TYPE = new TypedField<>(String.class, "billDocumentSonType");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
}
