package com.xforceplus.ultraman.app.matchingassets.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.matchingassets.entity.BillDocument;
import com.xforceplus.ultraman.app.matchingassets.service.IBillDocumentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-11
 */
@RestController
public class BillDocumentController {

  @Autowired
  private IBillDocumentService billDocumentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billDocument ${table.comment}
   * @return
   */
  @GetMapping("/billdocuments" )
  public XfR getBillDocuments(XfPage page, BillDocument billDocument) {
    return XfR.ok(billDocumentServiceImpl.page(page, Wrappers.query(billDocument)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billdocuments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billDocumentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billDocument ${table.comment}
   * @return XfR
   */
  @PostMapping("/billdocuments")
  public XfR save(@RequestBody BillDocument billDocument) {
     return XfR.ok(billDocumentServiceImpl.save(billDocument));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billDocument ${table.comment}
   * @return XfR
   */
  @PutMapping("/billdocuments/{id}")
  public XfR putUpdate(@RequestBody BillDocument billDocument,@PathVariable Long id) {
      billDocument.setId(id);
      return XfR.ok(billDocumentServiceImpl.updateById(billDocument));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billDocument ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billdocuments/{id}")
  public XfR patchUpdate(@RequestBody BillDocument billDocument,@PathVariable Long id) {
      BillDocument upbillDocument = billDocumentServiceImpl.getById(id);
      if(upbillDocument != null){
        upbillDocument = ObjectCopyUtils.copyProperties(billDocument,upbillDocument,true);
      }
      return XfR.ok(billDocumentServiceImpl.updateById(upbillDocument));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billdocuments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billDocumentServiceImpl.removeById(id));
  }

  @PostMapping("/billdocuments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_document");
     params.put("request", condition);

     return XfR.ok(billDocumentServiceImpl.querys(params));
  }

}
