package com.xforceplus.ultraman.app.matchingassets.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.matchingassets.entity.MatchingBill;
import com.xforceplus.ultraman.app.matchingassets.service.IMatchingBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-11
 */
@RestController
public class MatchingBillController {

  @Autowired
  private IMatchingBillService matchingBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchingBill ${table.comment}
   * @return
   */
  @GetMapping("/matchingbills" )
  public XfR getMatchingBills(XfPage page, MatchingBill matchingBill) {
    return XfR.ok(matchingBillServiceImpl.page(page, Wrappers.query(matchingBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchingbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchingBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param matchingBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/matchingbills")
  public XfR save(@RequestBody MatchingBill matchingBill) {
     return XfR.ok(matchingBillServiceImpl.save(matchingBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param matchingBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/matchingbills/{id}")
  public XfR putUpdate(@RequestBody MatchingBill matchingBill,@PathVariable Long id) {
      matchingBill.setId(id);
      return XfR.ok(matchingBillServiceImpl.updateById(matchingBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param matchingBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/matchingbills/{id}")
  public XfR patchUpdate(@RequestBody MatchingBill matchingBill,@PathVariable Long id) {
      MatchingBill upmatchingBill = matchingBillServiceImpl.getById(id);
      if(upmatchingBill != null){
        upmatchingBill = ObjectCopyUtils.copyProperties(matchingBill,upmatchingBill,true);
      }
      return XfR.ok(matchingBillServiceImpl.updateById(upmatchingBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchingbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchingBillServiceImpl.removeById(id));
  }

  @PostMapping("/matchingbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "matching_bill");
     params.put("request", condition);

     return XfR.ok(matchingBillServiceImpl.querys(params));
  }

}
