package com.xforceplus.ultraman.app.matchingassets.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.matchingassets.entity.MatchingBillItem;
import com.xforceplus.ultraman.app.matchingassets.service.IMatchingBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-11
 */
@RestController
public class MatchingBillItemController {

  @Autowired
  private IMatchingBillItemService matchingBillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchingBillItem ${table.comment}
   * @return
   */
  @GetMapping("/matchingbillitems" )
  public XfR getMatchingBillItems(XfPage page, MatchingBillItem matchingBillItem) {
    return XfR.ok(matchingBillItemServiceImpl.page(page, Wrappers.query(matchingBillItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchingbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchingBillItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param matchingBillItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/matchingbillitems")
  public XfR save(@RequestBody MatchingBillItem matchingBillItem) {
     return XfR.ok(matchingBillItemServiceImpl.save(matchingBillItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param matchingBillItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/matchingbillitems/{id}")
  public XfR putUpdate(@RequestBody MatchingBillItem matchingBillItem,@PathVariable Long id) {
      matchingBillItem.setId(id);
      return XfR.ok(matchingBillItemServiceImpl.updateById(matchingBillItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param matchingBillItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/matchingbillitems/{id}")
  public XfR patchUpdate(@RequestBody MatchingBillItem matchingBillItem,@PathVariable Long id) {
      MatchingBillItem upmatchingBillItem = matchingBillItemServiceImpl.getById(id);
      if(upmatchingBillItem != null){
        upmatchingBillItem = ObjectCopyUtils.copyProperties(matchingBillItem,upmatchingBillItem,true);
      }
      return XfR.ok(matchingBillItemServiceImpl.updateById(upmatchingBillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchingbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchingBillItemServiceImpl.removeById(id));
  }

  @PostMapping("/matchingbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "matching_bill_item");
     params.put("request", condition);

     return XfR.ok(matchingBillItemServiceImpl.querys(params));
  }

}
