package com.xforceplus.ultraman.app.matchingassets.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.matchingassets.entity.MatchingRule;
import com.xforceplus.ultraman.app.matchingassets.service.IMatchingRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-11
 */
@RestController
public class MatchingRuleController {

  @Autowired
  private IMatchingRuleService matchingRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchingRule ${table.comment}
   * @return
   */
  @GetMapping("/matchingrules" )
  public XfR getMatchingRules(XfPage page, MatchingRule matchingRule) {
    return XfR.ok(matchingRuleServiceImpl.page(page, Wrappers.query(matchingRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchingrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchingRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param matchingRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/matchingrules")
  public XfR save(@RequestBody MatchingRule matchingRule) {
     return XfR.ok(matchingRuleServiceImpl.save(matchingRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param matchingRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/matchingrules/{id}")
  public XfR putUpdate(@RequestBody MatchingRule matchingRule,@PathVariable Long id) {
      matchingRule.setId(id);
      return XfR.ok(matchingRuleServiceImpl.updateById(matchingRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param matchingRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/matchingrules/{id}")
  public XfR patchUpdate(@RequestBody MatchingRule matchingRule,@PathVariable Long id) {
      MatchingRule upmatchingRule = matchingRuleServiceImpl.getById(id);
      if(upmatchingRule != null){
        upmatchingRule = ObjectCopyUtils.copyProperties(matchingRule,upmatchingRule,true);
      }
      return XfR.ok(matchingRuleServiceImpl.updateById(upmatchingRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchingrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchingRuleServiceImpl.removeById(id));
  }

  @PostMapping("/matchingrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "matching_rule");
     params.put("request", condition);

     return XfR.ok(matchingRuleServiceImpl.querys(params));
  }

}
