package com.xforceplus.ultraman.app.new20.controller;


/**
 * zilei2feign客户端
 *
 * @author ultraman
 * @date 2023-05-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Zilei2;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "new20")
public interface Zilei2FeignApi {

  /**
   * 通过id查询zilei2
   * @param  id
   * @return R
   */
  @GetMapping("/zilei2/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增zilei2
   * @param zilei2 zilei2
   * @return R
   */
  @PostMapping("/zilei2/add")
  public R save(@RequestBody Zilei2 zilei2);

  /**
   * 修改zilei2
   * @param zilei2 zilei2
   * @return R
   */
  @PostMapping("/zilei2/update")
  public R updateById(@RequestBody Zilei2 zilei2);

  /**
   * 通过id删除zilei2
   * @param  id
   * @return R
   */
  @DeleteMapping("/zilei2/del/{id}" )
  public R removeById(@PathVariable Long id);

}