package com.xforceplus.ultraman.app.new20.controller;


/**
 * 123456789feign客户端
 *
 * @author ultraman
 * @date 2023-05-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Zilei3;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "new20")
public interface Zilei3FeignApi {

  /**
   * 通过id查询123456789
   * @param  id
   * @return R
   */
  @GetMapping("/zilei3/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增123456789
   * @param zilei3 123456789
   * @return R
   */
  @PostMapping("/zilei3/add")
  public R save(@RequestBody Zilei3 zilei3);

  /**
   * 修改123456789
   * @param zilei3 123456789
   * @return R
   */
  @PostMapping("/zilei3/update")
  public R updateById(@RequestBody Zilei3 zilei3);

  /**
   * 通过id删除123456789
   * @param  id
   * @return R
   */
  @DeleteMapping("/zilei3/del/{id}" )
  public R removeById(@PathVariable Long id);

}