package com.xforceplus.ultraman.app.new20.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * mjx003
 * </p>
 *
 * @author ultraman
 * @since 2023-05-22
 */
public enum Mjx003 {

    _0("0", "成功"),
    _1("1", "失败"),
    _2("2", "不知道");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Mjx003(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Mjx003 fromCode(String code) {
        return Stream.of(Mjx003.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
