package com.xforceplus.ultraman.app.new20.metadata.validator;

import com.xforceplus.ultraman.app.new20.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.new20.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-05-22
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx001.class)) {
            isValid = null != Mjx001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx002.class)) {
            isValid = null != Mjx002.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx002.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx003.class)) {
            isValid = null != Mjx003.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx003.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
