package com.xforceplus.ultraman.app.new20.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * mjx002
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum Mjx002 {

    _0("0", "成功"),
    _1("1", "失败"),
    _2("2", "不知道");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Mjx002(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Mjx002 fromCode(String code) {
        return Stream.of(Mjx002.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
