package com.xforceplus.ultraman.app.new20.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * relation0526001
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Relation0526001 implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * zfc0526001
   */
  private String zfc0526001;
  /**
   * zfc0526002
   */
  private String zfc0526002;
  /**
   * zx0526001
   */
  private Long zx0526001;
  /**
   * jine0526001
   */
  private BigDecimal jine0526001;
  /**
   * xs0526001
   */
  private BigDecimal xs0526001;
  /**
   * date0526001
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime date0526001;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * mjx0526001
   */
  private String mjx0526001;

  /**
   * 对一关联关系 关联对象 relation0526002
   */
  private Long ddygx0526001Id;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("zfc0526001", zfc0526001);
      map.put("zfc0526002", zfc0526002);
      map.put("zx0526001", zx0526001);
      map.put("jine0526001", jine0526001);
      map.put("xs0526001", xs0526001);
      map.put("date0526001", BocpGenUtils.toTimestamp(date0526001));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("mjx0526001", mjx0526001);

      map.put("ddygx0526001.id", ddygx0526001Id);
      return map;
  }

  public static Relation0526001 fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Relation0526001 entity = new Relation0526001();

    if(map.containsKey("zfc0526001")) {
      Object obj = map.get("zfc0526001");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc0526001((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfc0526002")) {
      Object obj = map.get("zfc0526002");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc0526002((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zx0526001")) {
      Object obj = map.get("zx0526001");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx0526001((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZx0526001(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setZx0526001(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("jine0526001")) {
      Object obj = map.get("jine0526001");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJine0526001((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJine0526001(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJine0526001(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJine0526001(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJine0526001(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("xs0526001")) {
      Object obj = map.get("xs0526001");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXs0526001((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXs0526001(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXs0526001(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXs0526001(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXs0526001(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("date0526001")) {
      Object obj = map.get("date0526001");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDate0526001(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDate0526001((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDate0526001(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDate0526001(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mjx0526001")) {
      Object obj = map.get("mjx0526001");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMjx0526001((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("ddygx0526001.id")) {
       Object obj = map.get("ddygx0526001.id");
       if(obj instanceof Long) {
         entity.setDdygx0526001Id((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setDdygx0526001Id(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc0526001")) {
      Object obj = map.get("zfc0526001");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZfc0526001((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfc0526002")) {
      Object obj = map.get("zfc0526002");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZfc0526002((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zx0526001")) {
      Object obj = map.get("zx0526001");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setZx0526001((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setZx0526001(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setZx0526001(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("jine0526001")) {
      Object obj = map.get("jine0526001");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setJine0526001((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setJine0526001(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setJine0526001(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJine0526001(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setJine0526001(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("xs0526001")) {
      Object obj = map.get("xs0526001");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setXs0526001((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setXs0526001(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setXs0526001(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setXs0526001(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setXs0526001(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("date0526001")) {
      Object obj = map.get("date0526001");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDate0526001(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDate0526001((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDate0526001(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDate0526001(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mjx0526001")) {
      Object obj = map.get("mjx0526001");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMjx0526001((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("ddygx0526001.id")) {
    Object obj = map.get("ddygx0526001.id");
    if(obj instanceof Long) {
        this.setDdygx0526001Id((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setDdygx0526001Id(Long.parseLong((String)obj));
    }
  }
  }
}
