package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Four0607001;
import com.xforceplus.ultraman.app.new20.service.IFour0607001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * four0607001.前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Four0607001Controller {

  @Autowired
  private IFour0607001Service four0607001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param four0607001 four0607001.
   * @return
   */
  @GetMapping("/four0607001s" )
  public XfR getFour0607001s(XfPage page, Four0607001 four0607001) {
    return XfR.ok(four0607001ServiceImpl.page(page, Wrappers.query(four0607001)));
  }

  /**
   * 通过id查询four0607001.
   * @param  id
   * @return XfR
   */
  @GetMapping("/four0607001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(four0607001ServiceImpl.getById(id));
  }

  /**
   * 新增four0607001.
   * @param four0607001 four0607001.
   * @return XfR
   */
  @PostMapping("/four0607001s")
  public XfR save(@RequestBody Four0607001 four0607001) {
     return XfR.ok(four0607001ServiceImpl.save(four0607001));
  }

  /**
   * 修改-传入修改后的全部数据four0607001.
   * @param four0607001 four0607001.
   * @return XfR
   */
  @PutMapping("/four0607001s/{id}")
  public XfR putUpdate(@RequestBody Four0607001 four0607001,@PathVariable Long id) {
      four0607001.setId(id);
      return XfR.ok(four0607001ServiceImpl.updateById(four0607001));
  }

  /**
   * 修改-传入修改的数据four0607001.
   * @param four0607001 four0607001.
   * @return XfR
   */
  @PatchMapping("/four0607001s/{id}")
  public XfR patchUpdate(@RequestBody Four0607001 four0607001,@PathVariable Long id) {
      Four0607001 upfour0607001 = four0607001ServiceImpl.getById(id);
      if(upfour0607001 != null){
        upfour0607001 = ObjectCopyUtils.copyProperties(four0607001,upfour0607001,true);
      }
      return XfR.ok(four0607001ServiceImpl.updateById(upfour0607001));
  }

  /**
   * 通过id删除four0607001.
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/four0607001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(four0607001ServiceImpl.removeById(id));
  }

  @PostMapping("/four0607001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "four0607001");
     params.put("request", condition);

     return XfR.ok(four0607001ServiceImpl.querys(params));
  }

}
