package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Fulei0625001;
import com.xforceplus.ultraman.app.new20.service.IFulei0625001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * fulei0625001前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Fulei0625001Controller {

  @Autowired
  private IFulei0625001Service fulei0625001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fulei0625001 fulei0625001
   * @return
   */
  @GetMapping("/fulei0625001s" )
  public XfR getFulei0625001s(XfPage page, Fulei0625001 fulei0625001) {
    return XfR.ok(fulei0625001ServiceImpl.page(page, Wrappers.query(fulei0625001)));
  }

  /**
   * 通过id查询fulei0625001
   * @param  id
   * @return XfR
   */
  @GetMapping("/fulei0625001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fulei0625001ServiceImpl.getById(id));
  }

  /**
   * 新增fulei0625001
   * @param fulei0625001 fulei0625001
   * @return XfR
   */
  @PostMapping("/fulei0625001s")
  public XfR save(@RequestBody Fulei0625001 fulei0625001) {
     return XfR.ok(fulei0625001ServiceImpl.save(fulei0625001));
  }

  /**
   * 修改-传入修改后的全部数据fulei0625001
   * @param fulei0625001 fulei0625001
   * @return XfR
   */
  @PutMapping("/fulei0625001s/{id}")
  public XfR putUpdate(@RequestBody Fulei0625001 fulei0625001,@PathVariable Long id) {
      fulei0625001.setId(id);
      return XfR.ok(fulei0625001ServiceImpl.updateById(fulei0625001));
  }

  /**
   * 修改-传入修改的数据fulei0625001
   * @param fulei0625001 fulei0625001
   * @return XfR
   */
  @PatchMapping("/fulei0625001s/{id}")
  public XfR patchUpdate(@RequestBody Fulei0625001 fulei0625001,@PathVariable Long id) {
      Fulei0625001 upfulei0625001 = fulei0625001ServiceImpl.getById(id);
      if(upfulei0625001 != null){
        upfulei0625001 = ObjectCopyUtils.copyProperties(fulei0625001,upfulei0625001,true);
      }
      return XfR.ok(fulei0625001ServiceImpl.updateById(upfulei0625001));
  }

  /**
   * 通过id删除fulei0625001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fulei0625001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fulei0625001ServiceImpl.removeById(id));
  }

  @PostMapping("/fulei0625001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fulei0625001");
     params.put("request", condition);

     return XfR.ok(fulei0625001ServiceImpl.querys(params));
  }

}
