package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.One0613001;
import com.xforceplus.ultraman.app.new20.service.IOne0613001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * one0613001.前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class One0613001Controller {

  @Autowired
  private IOne0613001Service one0613001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0613001 one0613001.
   * @return
   */
  @GetMapping("/one0613001s" )
  public XfR getOne0613001s(XfPage page, One0613001 one0613001) {
    return XfR.ok(one0613001ServiceImpl.page(page, Wrappers.query(one0613001)));
  }

  /**
   * 通过id查询one0613001.
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0613001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0613001ServiceImpl.getById(id));
  }

  /**
   * 新增one0613001.
   * @param one0613001 one0613001.
   * @return XfR
   */
  @PostMapping("/one0613001s")
  public XfR save(@RequestBody One0613001 one0613001) {
     return XfR.ok(one0613001ServiceImpl.save(one0613001));
  }

  /**
   * 修改-传入修改后的全部数据one0613001.
   * @param one0613001 one0613001.
   * @return XfR
   */
  @PutMapping("/one0613001s/{id}")
  public XfR putUpdate(@RequestBody One0613001 one0613001,@PathVariable Long id) {
      one0613001.setId(id);
      return XfR.ok(one0613001ServiceImpl.updateById(one0613001));
  }

  /**
   * 修改-传入修改的数据one0613001.
   * @param one0613001 one0613001.
   * @return XfR
   */
  @PatchMapping("/one0613001s/{id}")
  public XfR patchUpdate(@RequestBody One0613001 one0613001,@PathVariable Long id) {
      One0613001 upone0613001 = one0613001ServiceImpl.getById(id);
      if(upone0613001 != null){
        upone0613001 = ObjectCopyUtils.copyProperties(one0613001,upone0613001,true);
      }
      return XfR.ok(one0613001ServiceImpl.updateById(upone0613001));
  }

  /**
   * 通过id删除one0613001.
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0613001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0613001ServiceImpl.removeById(id));
  }

  @PostMapping("/one0613001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0613001");
     params.put("request", condition);

     return XfR.ok(one0613001ServiceImpl.querys(params));
  }

}
