package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.One0625004;
import com.xforceplus.ultraman.app.new20.service.IOne0625004Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * one0625004前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class One0625004Controller {

  @Autowired
  private IOne0625004Service one0625004ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0625004 one0625004
   * @return
   */
  @GetMapping("/one0625004s" )
  public XfR getOne0625004s(XfPage page, One0625004 one0625004) {
    return XfR.ok(one0625004ServiceImpl.page(page, Wrappers.query(one0625004)));
  }

  /**
   * 通过id查询one0625004
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0625004s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0625004ServiceImpl.getById(id));
  }

  /**
   * 新增one0625004
   * @param one0625004 one0625004
   * @return XfR
   */
  @PostMapping("/one0625004s")
  public XfR save(@RequestBody One0625004 one0625004) {
     return XfR.ok(one0625004ServiceImpl.save(one0625004));
  }

  /**
   * 修改-传入修改后的全部数据one0625004
   * @param one0625004 one0625004
   * @return XfR
   */
  @PutMapping("/one0625004s/{id}")
  public XfR putUpdate(@RequestBody One0625004 one0625004,@PathVariable Long id) {
      one0625004.setId(id);
      return XfR.ok(one0625004ServiceImpl.updateById(one0625004));
  }

  /**
   * 修改-传入修改的数据one0625004
   * @param one0625004 one0625004
   * @return XfR
   */
  @PatchMapping("/one0625004s/{id}")
  public XfR patchUpdate(@RequestBody One0625004 one0625004,@PathVariable Long id) {
      One0625004 upone0625004 = one0625004ServiceImpl.getById(id);
      if(upone0625004 != null){
        upone0625004 = ObjectCopyUtils.copyProperties(one0625004,upone0625004,true);
      }
      return XfR.ok(one0625004ServiceImpl.updateById(upone0625004));
  }

  /**
   * 通过id删除one0625004
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0625004s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0625004ServiceImpl.removeById(id));
  }

  @PostMapping("/one0625004s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0625004");
     params.put("request", condition);

     return XfR.ok(one0625004ServiceImpl.querys(params));
  }

}
