package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.One0706001;
import com.xforceplus.ultraman.app.new20.service.IOne0706001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * one0706001前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class One0706001Controller {

  @Autowired
  private IOne0706001Service one0706001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0706001 one0706001
   * @return
   */
  @GetMapping("/one0706001s" )
  public XfR getOne0706001s(XfPage page, One0706001 one0706001) {
    return XfR.ok(one0706001ServiceImpl.page(page, Wrappers.query(one0706001)));
  }

  /**
   * 通过id查询one0706001
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0706001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0706001ServiceImpl.getById(id));
  }

  /**
   * 新增one0706001
   * @param one0706001 one0706001
   * @return XfR
   */
  @PostMapping("/one0706001s")
  public XfR save(@RequestBody One0706001 one0706001) {
     return XfR.ok(one0706001ServiceImpl.save(one0706001));
  }

  /**
   * 修改-传入修改后的全部数据one0706001
   * @param one0706001 one0706001
   * @return XfR
   */
  @PutMapping("/one0706001s/{id}")
  public XfR putUpdate(@RequestBody One0706001 one0706001,@PathVariable Long id) {
      one0706001.setId(id);
      return XfR.ok(one0706001ServiceImpl.updateById(one0706001));
  }

  /**
   * 修改-传入修改的数据one0706001
   * @param one0706001 one0706001
   * @return XfR
   */
  @PatchMapping("/one0706001s/{id}")
  public XfR patchUpdate(@RequestBody One0706001 one0706001,@PathVariable Long id) {
      One0706001 upone0706001 = one0706001ServiceImpl.getById(id);
      if(upone0706001 != null){
        upone0706001 = ObjectCopyUtils.copyProperties(one0706001,upone0706001,true);
      }
      return XfR.ok(one0706001ServiceImpl.updateById(upone0706001));
  }

  /**
   * 通过id删除one0706001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0706001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0706001ServiceImpl.removeById(id));
  }

  @PostMapping("/one0706001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0706001");
     params.put("request", condition);

     return XfR.ok(one0706001ServiceImpl.querys(params));
  }

}
