package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.One0706002;
import com.xforceplus.ultraman.app.new20.service.IOne0706002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * one0706002前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class One0706002Controller {

  @Autowired
  private IOne0706002Service one0706002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0706002 one0706002
   * @return
   */
  @GetMapping("/one0706002s" )
  public XfR getOne0706002s(XfPage page, One0706002 one0706002) {
    return XfR.ok(one0706002ServiceImpl.page(page, Wrappers.query(one0706002)));
  }

  /**
   * 通过id查询one0706002
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0706002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0706002ServiceImpl.getById(id));
  }

  /**
   * 新增one0706002
   * @param one0706002 one0706002
   * @return XfR
   */
  @PostMapping("/one0706002s")
  public XfR save(@RequestBody One0706002 one0706002) {
     return XfR.ok(one0706002ServiceImpl.save(one0706002));
  }

  /**
   * 修改-传入修改后的全部数据one0706002
   * @param one0706002 one0706002
   * @return XfR
   */
  @PutMapping("/one0706002s/{id}")
  public XfR putUpdate(@RequestBody One0706002 one0706002,@PathVariable Long id) {
      one0706002.setId(id);
      return XfR.ok(one0706002ServiceImpl.updateById(one0706002));
  }

  /**
   * 修改-传入修改的数据one0706002
   * @param one0706002 one0706002
   * @return XfR
   */
  @PatchMapping("/one0706002s/{id}")
  public XfR patchUpdate(@RequestBody One0706002 one0706002,@PathVariable Long id) {
      One0706002 upone0706002 = one0706002ServiceImpl.getById(id);
      if(upone0706002 != null){
        upone0706002 = ObjectCopyUtils.copyProperties(one0706002,upone0706002,true);
      }
      return XfR.ok(one0706002ServiceImpl.updateById(upone0706002));
  }

  /**
   * 通过id删除one0706002
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0706002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0706002ServiceImpl.removeById(id));
  }

  @PostMapping("/one0706002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0706002");
     params.put("request", condition);

     return XfR.ok(one0706002ServiceImpl.querys(params));
  }

}
