package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Oneobject7;
import com.xforceplus.ultraman.app.new20.service.IOneobject7Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * oneobject7前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Oneobject7Controller {

  @Autowired
  private IOneobject7Service oneobject7ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneobject7 oneobject7
   * @return
   */
  @GetMapping("/oneobject7s" )
  public XfR getOneobject7s(XfPage page, Oneobject7 oneobject7) {
    return XfR.ok(oneobject7ServiceImpl.page(page, Wrappers.query(oneobject7)));
  }

  /**
   * 通过id查询oneobject7
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneobject7s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneobject7ServiceImpl.getById(id));
  }

  /**
   * 新增oneobject7
   * @param oneobject7 oneobject7
   * @return XfR
   */
  @PostMapping("/oneobject7s")
  public XfR save(@RequestBody Oneobject7 oneobject7) {
     return XfR.ok(oneobject7ServiceImpl.save(oneobject7));
  }

  /**
   * 修改-传入修改后的全部数据oneobject7
   * @param oneobject7 oneobject7
   * @return XfR
   */
  @PutMapping("/oneobject7s/{id}")
  public XfR putUpdate(@RequestBody Oneobject7 oneobject7,@PathVariable Long id) {
      oneobject7.setId(id);
      return XfR.ok(oneobject7ServiceImpl.updateById(oneobject7));
  }

  /**
   * 修改-传入修改的数据oneobject7
   * @param oneobject7 oneobject7
   * @return XfR
   */
  @PatchMapping("/oneobject7s/{id}")
  public XfR patchUpdate(@RequestBody Oneobject7 oneobject7,@PathVariable Long id) {
      Oneobject7 uponeobject7 = oneobject7ServiceImpl.getById(id);
      if(uponeobject7 != null){
        uponeobject7 = ObjectCopyUtils.copyProperties(oneobject7,uponeobject7,true);
      }
      return XfR.ok(oneobject7ServiceImpl.updateById(uponeobject7));
  }

  /**
   * 通过id删除oneobject7
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneobject7s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneobject7ServiceImpl.removeById(id));
  }

  @PostMapping("/oneobject7s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneobject7");
     params.put("request", condition);

     return XfR.ok(oneobject7ServiceImpl.querys(params));
  }

}
