package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Oneobject9;
import com.xforceplus.ultraman.app.new20.service.IOneobject9Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * oneobject9前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Oneobject9Controller {

  @Autowired
  private IOneobject9Service oneobject9ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneobject9 oneobject9
   * @return
   */
  @GetMapping("/oneobject9s" )
  public XfR getOneobject9s(XfPage page, Oneobject9 oneobject9) {
    return XfR.ok(oneobject9ServiceImpl.page(page, Wrappers.query(oneobject9)));
  }

  /**
   * 通过id查询oneobject9
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneobject9s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneobject9ServiceImpl.getById(id));
  }

  /**
   * 新增oneobject9
   * @param oneobject9 oneobject9
   * @return XfR
   */
  @PostMapping("/oneobject9s")
  public XfR save(@RequestBody Oneobject9 oneobject9) {
     return XfR.ok(oneobject9ServiceImpl.save(oneobject9));
  }

  /**
   * 修改-传入修改后的全部数据oneobject9
   * @param oneobject9 oneobject9
   * @return XfR
   */
  @PutMapping("/oneobject9s/{id}")
  public XfR putUpdate(@RequestBody Oneobject9 oneobject9,@PathVariable Long id) {
      oneobject9.setId(id);
      return XfR.ok(oneobject9ServiceImpl.updateById(oneobject9));
  }

  /**
   * 修改-传入修改的数据oneobject9
   * @param oneobject9 oneobject9
   * @return XfR
   */
  @PatchMapping("/oneobject9s/{id}")
  public XfR patchUpdate(@RequestBody Oneobject9 oneobject9,@PathVariable Long id) {
      Oneobject9 uponeobject9 = oneobject9ServiceImpl.getById(id);
      if(uponeobject9 != null){
        uponeobject9 = ObjectCopyUtils.copyProperties(oneobject9,uponeobject9,true);
      }
      return XfR.ok(oneobject9ServiceImpl.updateById(uponeobject9));
  }

  /**
   * 通过id删除oneobject9
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneobject9s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneobject9ServiceImpl.removeById(id));
  }

  @PostMapping("/oneobject9s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneobject9");
     params.put("request", condition);

     return XfR.ok(oneobject9ServiceImpl.querys(params));
  }

}
