package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Relation0526001;
import com.xforceplus.ultraman.app.new20.service.IRelation0526001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * relation0526001前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Relation0526001Controller {

  @Autowired
  private IRelation0526001Service relation0526001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param relation0526001 relation0526001
   * @return
   */
  @GetMapping("/relation0526001s" )
  public XfR getRelation0526001s(XfPage page, Relation0526001 relation0526001) {
    return XfR.ok(relation0526001ServiceImpl.page(page, Wrappers.query(relation0526001)));
  }

  /**
   * 通过id查询relation0526001
   * @param  id
   * @return XfR
   */
  @GetMapping("/relation0526001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(relation0526001ServiceImpl.getById(id));
  }

  /**
   * 新增relation0526001
   * @param relation0526001 relation0526001
   * @return XfR
   */
  @PostMapping("/relation0526001s")
  public XfR save(@RequestBody Relation0526001 relation0526001) {
     return XfR.ok(relation0526001ServiceImpl.save(relation0526001));
  }

  /**
   * 修改-传入修改后的全部数据relation0526001
   * @param relation0526001 relation0526001
   * @return XfR
   */
  @PutMapping("/relation0526001s/{id}")
  public XfR putUpdate(@RequestBody Relation0526001 relation0526001,@PathVariable Long id) {
      relation0526001.setId(id);
      return XfR.ok(relation0526001ServiceImpl.updateById(relation0526001));
  }

  /**
   * 修改-传入修改的数据relation0526001
   * @param relation0526001 relation0526001
   * @return XfR
   */
  @PatchMapping("/relation0526001s/{id}")
  public XfR patchUpdate(@RequestBody Relation0526001 relation0526001,@PathVariable Long id) {
      Relation0526001 uprelation0526001 = relation0526001ServiceImpl.getById(id);
      if(uprelation0526001 != null){
        uprelation0526001 = ObjectCopyUtils.copyProperties(relation0526001,uprelation0526001,true);
      }
      return XfR.ok(relation0526001ServiceImpl.updateById(uprelation0526001));
  }

  /**
   * 通过id删除relation0526001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/relation0526001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(relation0526001ServiceImpl.removeById(id));
  }

  @PostMapping("/relation0526001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "relation0526001");
     params.put("request", condition);

     return XfR.ok(relation0526001ServiceImpl.querys(params));
  }

}
