package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Test0605001;
import com.xforceplus.ultraman.app.new20.service.ITest0605001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0605001前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Test0605001Controller {

  @Autowired
  private ITest0605001Service test0605001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0605001 test0605001
   * @return
   */
  @GetMapping("/test0605001s" )
  public XfR getTest0605001s(XfPage page, Test0605001 test0605001) {
    return XfR.ok(test0605001ServiceImpl.page(page, Wrappers.query(test0605001)));
  }

  /**
   * 通过id查询test0605001
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0605001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0605001ServiceImpl.getById(id));
  }

  /**
   * 新增test0605001
   * @param test0605001 test0605001
   * @return XfR
   */
  @PostMapping("/test0605001s")
  public XfR save(@RequestBody Test0605001 test0605001) {
     return XfR.ok(test0605001ServiceImpl.save(test0605001));
  }

  /**
   * 修改-传入修改后的全部数据test0605001
   * @param test0605001 test0605001
   * @return XfR
   */
  @PutMapping("/test0605001s/{id}")
  public XfR putUpdate(@RequestBody Test0605001 test0605001,@PathVariable Long id) {
      test0605001.setId(id);
      return XfR.ok(test0605001ServiceImpl.updateById(test0605001));
  }

  /**
   * 修改-传入修改的数据test0605001
   * @param test0605001 test0605001
   * @return XfR
   */
  @PatchMapping("/test0605001s/{id}")
  public XfR patchUpdate(@RequestBody Test0605001 test0605001,@PathVariable Long id) {
      Test0605001 uptest0605001 = test0605001ServiceImpl.getById(id);
      if(uptest0605001 != null){
        uptest0605001 = ObjectCopyUtils.copyProperties(test0605001,uptest0605001,true);
      }
      return XfR.ok(test0605001ServiceImpl.updateById(uptest0605001));
  }

  /**
   * 通过id删除test0605001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0605001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0605001ServiceImpl.removeById(id));
  }

  @PostMapping("/test0605001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0605001");
     params.put("request", condition);

     return XfR.ok(test0605001ServiceImpl.querys(params));
  }

}
