package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Test0630001;
import com.xforceplus.ultraman.app.new20.service.ITest0630001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0630001前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Test0630001Controller {

  @Autowired
  private ITest0630001Service test0630001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0630001 test0630001
   * @return
   */
  @GetMapping("/test0630001s" )
  public XfR getTest0630001s(XfPage page, Test0630001 test0630001) {
    return XfR.ok(test0630001ServiceImpl.page(page, Wrappers.query(test0630001)));
  }

  /**
   * 通过id查询test0630001
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0630001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0630001ServiceImpl.getById(id));
  }

  /**
   * 新增test0630001
   * @param test0630001 test0630001
   * @return XfR
   */
  @PostMapping("/test0630001s")
  public XfR save(@RequestBody Test0630001 test0630001) {
     return XfR.ok(test0630001ServiceImpl.save(test0630001));
  }

  /**
   * 修改-传入修改后的全部数据test0630001
   * @param test0630001 test0630001
   * @return XfR
   */
  @PutMapping("/test0630001s/{id}")
  public XfR putUpdate(@RequestBody Test0630001 test0630001,@PathVariable Long id) {
      test0630001.setId(id);
      return XfR.ok(test0630001ServiceImpl.updateById(test0630001));
  }

  /**
   * 修改-传入修改的数据test0630001
   * @param test0630001 test0630001
   * @return XfR
   */
  @PatchMapping("/test0630001s/{id}")
  public XfR patchUpdate(@RequestBody Test0630001 test0630001,@PathVariable Long id) {
      Test0630001 uptest0630001 = test0630001ServiceImpl.getById(id);
      if(uptest0630001 != null){
        uptest0630001 = ObjectCopyUtils.copyProperties(test0630001,uptest0630001,true);
      }
      return XfR.ok(test0630001ServiceImpl.updateById(uptest0630001));
  }

  /**
   * 通过id删除test0630001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0630001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0630001ServiceImpl.removeById(id));
  }

  @PostMapping("/test0630001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0630001");
     params.put("request", condition);

     return XfR.ok(test0630001ServiceImpl.querys(params));
  }

}
