package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Test0719001;
import com.xforceplus.ultraman.app.new20.service.ITest0719001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0719001前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Test0719001Controller {

  @Autowired
  private ITest0719001Service test0719001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0719001 test0719001
   * @return
   */
  @GetMapping("/test0719001s" )
  public XfR getTest0719001s(XfPage page, Test0719001 test0719001) {
    return XfR.ok(test0719001ServiceImpl.page(page, Wrappers.query(test0719001)));
  }

  /**
   * 通过id查询test0719001
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0719001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0719001ServiceImpl.getById(id));
  }

  /**
   * 新增test0719001
   * @param test0719001 test0719001
   * @return XfR
   */
  @PostMapping("/test0719001s")
  public XfR save(@RequestBody Test0719001 test0719001) {
     return XfR.ok(test0719001ServiceImpl.save(test0719001));
  }

  /**
   * 修改-传入修改后的全部数据test0719001
   * @param test0719001 test0719001
   * @return XfR
   */
  @PutMapping("/test0719001s/{id}")
  public XfR putUpdate(@RequestBody Test0719001 test0719001,@PathVariable Long id) {
      test0719001.setId(id);
      return XfR.ok(test0719001ServiceImpl.updateById(test0719001));
  }

  /**
   * 修改-传入修改的数据test0719001
   * @param test0719001 test0719001
   * @return XfR
   */
  @PatchMapping("/test0719001s/{id}")
  public XfR patchUpdate(@RequestBody Test0719001 test0719001,@PathVariable Long id) {
      Test0719001 uptest0719001 = test0719001ServiceImpl.getById(id);
      if(uptest0719001 != null){
        uptest0719001 = ObjectCopyUtils.copyProperties(test0719001,uptest0719001,true);
      }
      return XfR.ok(test0719001ServiceImpl.updateById(uptest0719001));
  }

  /**
   * 通过id删除test0719001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0719001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0719001ServiceImpl.removeById(id));
  }

  @PostMapping("/test0719001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0719001");
     params.put("request", condition);

     return XfR.ok(test0719001ServiceImpl.querys(params));
  }

}
