package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Test0719003;
import com.xforceplus.ultraman.app.new20.service.ITest0719003Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0719003前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Test0719003Controller {

  @Autowired
  private ITest0719003Service test0719003ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0719003 test0719003
   * @return
   */
  @GetMapping("/test0719003s" )
  public XfR getTest0719003s(XfPage page, Test0719003 test0719003) {
    return XfR.ok(test0719003ServiceImpl.page(page, Wrappers.query(test0719003)));
  }

  /**
   * 通过id查询test0719003
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0719003s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0719003ServiceImpl.getById(id));
  }

  /**
   * 新增test0719003
   * @param test0719003 test0719003
   * @return XfR
   */
  @PostMapping("/test0719003s")
  public XfR save(@RequestBody Test0719003 test0719003) {
     return XfR.ok(test0719003ServiceImpl.save(test0719003));
  }

  /**
   * 修改-传入修改后的全部数据test0719003
   * @param test0719003 test0719003
   * @return XfR
   */
  @PutMapping("/test0719003s/{id}")
  public XfR putUpdate(@RequestBody Test0719003 test0719003,@PathVariable Long id) {
      test0719003.setId(id);
      return XfR.ok(test0719003ServiceImpl.updateById(test0719003));
  }

  /**
   * 修改-传入修改的数据test0719003
   * @param test0719003 test0719003
   * @return XfR
   */
  @PatchMapping("/test0719003s/{id}")
  public XfR patchUpdate(@RequestBody Test0719003 test0719003,@PathVariable Long id) {
      Test0719003 uptest0719003 = test0719003ServiceImpl.getById(id);
      if(uptest0719003 != null){
        uptest0719003 = ObjectCopyUtils.copyProperties(test0719003,uptest0719003,true);
      }
      return XfR.ok(test0719003ServiceImpl.updateById(uptest0719003));
  }

  /**
   * 通过id删除test0719003
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0719003s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0719003ServiceImpl.removeById(id));
  }

  @PostMapping("/test0719003s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0719003");
     params.put("request", condition);

     return XfR.ok(test0719003ServiceImpl.querys(params));
  }

}
