package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Test0719006;
import com.xforceplus.ultraman.app.new20.service.ITest0719006Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Test0719006Controller {

  @Autowired
  private ITest0719006Service test0719006ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0719006 ${table.comment}
   * @return
   */
  @GetMapping("/test0719006s" )
  public XfR getTest0719006s(XfPage page, Test0719006 test0719006) {
    return XfR.ok(test0719006ServiceImpl.page(page, Wrappers.query(test0719006)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0719006s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0719006ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test0719006 ${table.comment}
   * @return XfR
   */
  @PostMapping("/test0719006s")
  public XfR save(@RequestBody Test0719006 test0719006) {
     return XfR.ok(test0719006ServiceImpl.save(test0719006));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test0719006 ${table.comment}
   * @return XfR
   */
  @PutMapping("/test0719006s/{id}")
  public XfR putUpdate(@RequestBody Test0719006 test0719006,@PathVariable Long id) {
      test0719006.setId(id);
      return XfR.ok(test0719006ServiceImpl.updateById(test0719006));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test0719006 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test0719006s/{id}")
  public XfR patchUpdate(@RequestBody Test0719006 test0719006,@PathVariable Long id) {
      Test0719006 uptest0719006 = test0719006ServiceImpl.getById(id);
      if(uptest0719006 != null){
        uptest0719006 = ObjectCopyUtils.copyProperties(test0719006,uptest0719006,true);
      }
      return XfR.ok(test0719006ServiceImpl.updateById(uptest0719006));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0719006s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0719006ServiceImpl.removeById(id));
  }

  @PostMapping("/test0719006s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0719006");
     params.put("request", condition);

     return XfR.ok(test0719006ServiceImpl.querys(params));
  }

}
