package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Yacees0530001;
import com.xforceplus.ultraman.app.new20.service.IYacees0530001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * yacees0530001x前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Yacees0530001Controller {

  @Autowired
  private IYacees0530001Service yacees0530001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yacees0530001 yacees0530001x
   * @return
   */
  @GetMapping("/yacees0530001s" )
  public XfR getYacees0530001s(XfPage page, Yacees0530001 yacees0530001) {
    return XfR.ok(yacees0530001ServiceImpl.page(page, Wrappers.query(yacees0530001)));
  }

  /**
   * 通过id查询yacees0530001x
   * @param  id
   * @return XfR
   */
  @GetMapping("/yacees0530001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yacees0530001ServiceImpl.getById(id));
  }

  /**
   * 新增yacees0530001x
   * @param yacees0530001 yacees0530001x
   * @return XfR
   */
  @PostMapping("/yacees0530001s")
  public XfR save(@RequestBody Yacees0530001 yacees0530001) {
     return XfR.ok(yacees0530001ServiceImpl.save(yacees0530001));
  }

  /**
   * 修改-传入修改后的全部数据yacees0530001x
   * @param yacees0530001 yacees0530001x
   * @return XfR
   */
  @PutMapping("/yacees0530001s/{id}")
  public XfR putUpdate(@RequestBody Yacees0530001 yacees0530001,@PathVariable Long id) {
      yacees0530001.setId(id);
      return XfR.ok(yacees0530001ServiceImpl.updateById(yacees0530001));
  }

  /**
   * 修改-传入修改的数据yacees0530001x
   * @param yacees0530001 yacees0530001x
   * @return XfR
   */
  @PatchMapping("/yacees0530001s/{id}")
  public XfR patchUpdate(@RequestBody Yacees0530001 yacees0530001,@PathVariable Long id) {
      Yacees0530001 upyacees0530001 = yacees0530001ServiceImpl.getById(id);
      if(upyacees0530001 != null){
        upyacees0530001 = ObjectCopyUtils.copyProperties(yacees0530001,upyacees0530001,true);
      }
      return XfR.ok(yacees0530001ServiceImpl.updateById(upyacees0530001));
  }

  /**
   * 通过id删除yacees0530001x
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yacees0530001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yacees0530001ServiceImpl.removeById(id));
  }

  @PostMapping("/yacees0530001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yacees0530001");
     params.put("request", condition);

     return XfR.ok(yacees0530001ServiceImpl.querys(params));
  }

}
