package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Zilei0506001;
import com.xforceplus.ultraman.app.new20.service.IZilei0506001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * zilei0506001前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Zilei0506001Controller {

  @Autowired
  private IZilei0506001Service zilei0506001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei0506001 zilei0506001
   * @return
   */
  @GetMapping("/zilei0506001s" )
  public XfR getZilei0506001s(XfPage page, Zilei0506001 zilei0506001) {
    return XfR.ok(zilei0506001ServiceImpl.page(page, Wrappers.query(zilei0506001)));
  }

  /**
   * 通过id查询zilei0506001
   * @param  id
   * @return XfR
   */
  @GetMapping("/zilei0506001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zilei0506001ServiceImpl.getById(id));
  }

  /**
   * 新增zilei0506001
   * @param zilei0506001 zilei0506001
   * @return XfR
   */
  @PostMapping("/zilei0506001s")
  public XfR save(@RequestBody Zilei0506001 zilei0506001) {
     return XfR.ok(zilei0506001ServiceImpl.save(zilei0506001));
  }

  /**
   * 修改-传入修改后的全部数据zilei0506001
   * @param zilei0506001 zilei0506001
   * @return XfR
   */
  @PutMapping("/zilei0506001s/{id}")
  public XfR putUpdate(@RequestBody Zilei0506001 zilei0506001,@PathVariable Long id) {
      zilei0506001.setId(id);
      return XfR.ok(zilei0506001ServiceImpl.updateById(zilei0506001));
  }

  /**
   * 修改-传入修改的数据zilei0506001
   * @param zilei0506001 zilei0506001
   * @return XfR
   */
  @PatchMapping("/zilei0506001s/{id}")
  public XfR patchUpdate(@RequestBody Zilei0506001 zilei0506001,@PathVariable Long id) {
      Zilei0506001 upzilei0506001 = zilei0506001ServiceImpl.getById(id);
      if(upzilei0506001 != null){
        upzilei0506001 = ObjectCopyUtils.copyProperties(zilei0506001,upzilei0506001,true);
      }
      return XfR.ok(zilei0506001ServiceImpl.updateById(upzilei0506001));
  }

  /**
   * 通过id删除zilei0506001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zilei0506001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zilei0506001ServiceImpl.removeById(id));
  }

  @PostMapping("/zilei0506001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei0506001");
     params.put("request", condition);

     return XfR.ok(zilei0506001ServiceImpl.querys(params));
  }

}
