package com.xforceplus.ultraman.app.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.new20.entity.Zilei3;
import com.xforceplus.ultraman.app.new20.service.IZilei3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 123456789前端控制器
 *
 * @author ultraman
 * @date 2023-07-24
 */
@RestController
public class Zilei3Controller {

  @Autowired
  private IZilei3Service zilei3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei3 123456789
   * @return
   */
  @GetMapping("/zilei3s" )
  public XfR getZilei3s(XfPage page, Zilei3 zilei3) {
    return XfR.ok(zilei3ServiceImpl.page(page, Wrappers.query(zilei3)));
  }

  /**
   * 通过id查询123456789
   * @param  id
   * @return XfR
   */
  @GetMapping("/zilei3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zilei3ServiceImpl.getById(id));
  }

  /**
   * 新增123456789
   * @param zilei3 123456789
   * @return XfR
   */
  @PostMapping("/zilei3s")
  public XfR save(@RequestBody Zilei3 zilei3) {
     return XfR.ok(zilei3ServiceImpl.save(zilei3));
  }

  /**
   * 修改-传入修改后的全部数据123456789
   * @param zilei3 123456789
   * @return XfR
   */
  @PutMapping("/zilei3s/{id}")
  public XfR putUpdate(@RequestBody Zilei3 zilei3,@PathVariable Long id) {
      zilei3.setId(id);
      return XfR.ok(zilei3ServiceImpl.updateById(zilei3));
  }

  /**
   * 修改-传入修改的数据123456789
   * @param zilei3 123456789
   * @return XfR
   */
  @PatchMapping("/zilei3s/{id}")
  public XfR patchUpdate(@RequestBody Zilei3 zilei3,@PathVariable Long id) {
      Zilei3 upzilei3 = zilei3ServiceImpl.getById(id);
      if(upzilei3 != null){
        upzilei3 = ObjectCopyUtils.copyProperties(zilei3,upzilei3,true);
      }
      return XfR.ok(zilei3ServiceImpl.updateById(upzilei3));
  }

  /**
   * 通过id删除123456789
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zilei3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zilei3ServiceImpl.removeById(id));
  }

  @PostMapping("/zilei3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei3");
     params.put("request", condition);

     return XfR.ok(zilei3ServiceImpl.querys(params));
  }

}
