package com.xforceplus.ultraman.app.new203.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * mjx0804001
 * </p>
 *
 * @author ultraman
 * @since 2023-08-14
 */
public enum Mjx0804001 {

    _0("0", "失败"),
    _1("1", "成功"),
    _2("2", "勾选中"),
    _3("3", "部分勾选"),
    _4("4", "全部勾选");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Mjx0804001(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Mjx0804001 fromCode(String code) {
        return Stream.of(Mjx0804001.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
