package com.xforceplus.ultraman.app.new203.metadata.validator;

import com.xforceplus.ultraman.app.new203.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.new203.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-08-14
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx0803001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx0803001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx0803001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx0804001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx0804001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx0804001.class.getSimpleName());
            }
        }
        if(clazz.equals(Bizmjx0812001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Bizmjx0812001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Bizmjx0812001.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
