package com.xforceplus.ultraman.app.newoqsapp1.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.newoqsapp1.entity.Test1217001;
import com.xforceplus.ultraman.app.newoqsapp1.service.ITest1217001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test1217001前端控制器
 *
 * @author ultraman
 * @date 2023-01-03
 */
@RestController
public class Test1217001Controller {

  @Autowired
  private ITest1217001Service test1217001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test1217001 test1217001
   * @return
   */
  @GetMapping("/test1217001s" )
  public XfR getTest1217001s(XfPage page, Test1217001 test1217001) {
    return XfR.ok(test1217001ServiceImpl.page(page, Wrappers.query(test1217001)));
  }

  /**
   * 通过id查询test1217001
   * @param  id
   * @return XfR
   */
  @GetMapping("/test1217001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test1217001ServiceImpl.getById(id));
  }

  /**
   * 新增test1217001
   * @param test1217001 test1217001
   * @return XfR
   */
  @PostMapping("/test1217001s")
  public XfR save(@RequestBody Test1217001 test1217001) {
     return XfR.ok(test1217001ServiceImpl.save(test1217001));
  }

  /**
   * 修改-传入修改后的全部数据test1217001
   * @param test1217001 test1217001
   * @return XfR
   */
  @PutMapping("/test1217001s/{id}")
  public XfR putUpdate(@RequestBody Test1217001 test1217001,@PathVariable Long id) {
      test1217001.setId(id);
      return XfR.ok(test1217001ServiceImpl.updateById(test1217001));
  }

  /**
   * 修改-传入修改的数据test1217001
   * @param test1217001 test1217001
   * @return XfR
   */
  @PatchMapping("/test1217001s/{id}")
  public XfR patchUpdate(@RequestBody Test1217001 test1217001,@PathVariable Long id) {
      Test1217001 uptest1217001 = test1217001ServiceImpl.getById(id);
      if(uptest1217001 != null){
        uptest1217001 = ObjectCopyUtils.copyProperties(test1217001,uptest1217001,true);
      }
      return XfR.ok(test1217001ServiceImpl.updateById(uptest1217001));
  }

  /**
   * 通过id删除test1217001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test1217001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test1217001ServiceImpl.removeById(id));
  }

  @PostMapping("/test1217001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test1217001");
     params.put("request", condition);

     return XfR.ok(test1217001ServiceImpl.querys(params));
  }

}
