package com.xforceplus.ultraman.app.oldtonewversion0510.controller;


/**
 * 信息表与确认单共用feign客户端
 *
 * @author ultraman
 * @date 2023-05-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.oldtonewversion0510.entity.RedInvoiceDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "oldtonewversion0510")
public interface RedInvoiceDetailFeignApi {

  /**
   * 通过id查询信息表与确认单共用
   * @param  id
   * @return R
   */
  @GetMapping("/redInvoiceDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增信息表与确认单共用
   * @param redInvoiceDetail 信息表与确认单共用
   * @return R
   */
  @PostMapping("/redInvoiceDetail/add")
  public R save(@RequestBody RedInvoiceDetail redInvoiceDetail);

  /**
   * 修改信息表与确认单共用
   * @param redInvoiceDetail 信息表与确认单共用
   * @return R
   */
  @PostMapping("/redInvoiceDetail/update")
  public R updateById(@RequestBody RedInvoiceDetail redInvoiceDetail);

  /**
   * 通过id删除信息表与确认单共用
   * @param  id
   * @return R
   */
  @DeleteMapping("/redInvoiceDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}