package com.xforceplus.ultraman.app.oldtonewversion0510.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.oldtonewversion0510.entity.AttachmentManage;
import com.xforceplus.ultraman.app.oldtonewversion0510.service.IAttachmentManageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-11
 */
@RestController
public class AttachmentManageController {

  @Autowired
  private IAttachmentManageService attachmentManageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param attachmentManage ${table.comment}
   * @return
   */
  @GetMapping("/attachmentmanages" )
  public XfR getAttachmentManages(XfPage page, AttachmentManage attachmentManage) {
    return XfR.ok(attachmentManageServiceImpl.page(page, Wrappers.query(attachmentManage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/attachmentmanages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(attachmentManageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param attachmentManage ${table.comment}
   * @return XfR
   */
  @PostMapping("/attachmentmanages")
  public XfR save(@RequestBody AttachmentManage attachmentManage) {
     return XfR.ok(attachmentManageServiceImpl.save(attachmentManage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param attachmentManage ${table.comment}
   * @return XfR
   */
  @PutMapping("/attachmentmanages/{id}")
  public XfR putUpdate(@RequestBody AttachmentManage attachmentManage,@PathVariable Long id) {
      attachmentManage.setId(id);
      return XfR.ok(attachmentManageServiceImpl.updateById(attachmentManage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param attachmentManage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/attachmentmanages/{id}")
  public XfR patchUpdate(@RequestBody AttachmentManage attachmentManage,@PathVariable Long id) {
      AttachmentManage upattachmentManage = attachmentManageServiceImpl.getById(id);
      if(upattachmentManage != null){
        upattachmentManage = ObjectCopyUtils.copyProperties(attachmentManage,upattachmentManage,true);
      }
      return XfR.ok(attachmentManageServiceImpl.updateById(upattachmentManage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/attachmentmanages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(attachmentManageServiceImpl.removeById(id));
  }

  @PostMapping("/attachmentmanages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "attachment_manage");
     params.put("request", condition);

     return XfR.ok(attachmentManageServiceImpl.querys(params));
  }

}
