package com.xforceplus.ultraman.app.oldtonewversion0510.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.oldtonewversion0510.entity.GroupInfo;
import com.xforceplus.ultraman.app.oldtonewversion0510.service.IGroupInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 组别相关信息包含对应的分录数据前端控制器
 *
 * @author ultraman
 * @date 2023-05-11
 */
@RestController
public class GroupInfoController {

  @Autowired
  private IGroupInfoService groupInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param groupInfo 组别相关信息包含对应的分录数据
   * @return
   */
  @GetMapping("/groupinfos" )
  public XfR getGroupInfos(XfPage page, GroupInfo groupInfo) {
    return XfR.ok(groupInfoServiceImpl.page(page, Wrappers.query(groupInfo)));
  }

  /**
   * 通过id查询组别相关信息包含对应的分录数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/groupinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(groupInfoServiceImpl.getById(id));
  }

  /**
   * 新增组别相关信息包含对应的分录数据
   * @param groupInfo 组别相关信息包含对应的分录数据
   * @return XfR
   */
  @PostMapping("/groupinfos")
  public XfR save(@RequestBody GroupInfo groupInfo) {
     return XfR.ok(groupInfoServiceImpl.save(groupInfo));
  }

  /**
   * 修改-传入修改后的全部数据组别相关信息包含对应的分录数据
   * @param groupInfo 组别相关信息包含对应的分录数据
   * @return XfR
   */
  @PutMapping("/groupinfos/{id}")
  public XfR putUpdate(@RequestBody GroupInfo groupInfo,@PathVariable Long id) {
      groupInfo.setId(id);
      return XfR.ok(groupInfoServiceImpl.updateById(groupInfo));
  }

  /**
   * 修改-传入修改的数据组别相关信息包含对应的分录数据
   * @param groupInfo 组别相关信息包含对应的分录数据
   * @return XfR
   */
  @PatchMapping("/groupinfos/{id}")
  public XfR patchUpdate(@RequestBody GroupInfo groupInfo,@PathVariable Long id) {
      GroupInfo upgroupInfo = groupInfoServiceImpl.getById(id);
      if(upgroupInfo != null){
        upgroupInfo = ObjectCopyUtils.copyProperties(groupInfo,upgroupInfo,true);
      }
      return XfR.ok(groupInfoServiceImpl.updateById(upgroupInfo));
  }

  /**
   * 通过id删除组别相关信息包含对应的分录数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/groupinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(groupInfoServiceImpl.removeById(id));
  }

  @PostMapping("/groupinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "group_info");
     params.put("request", condition);

     return XfR.ok(groupInfoServiceImpl.querys(params));
  }

}
