package com.xforceplus.ultraman.app.oldtonewversion0510.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.oldtonewversion0510.entity.RedFollow;
import com.xforceplus.ultraman.app.oldtonewversion0510.service.IRedFollowService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-11
 */
@RestController
public class RedFollowController {

  @Autowired
  private IRedFollowService redFollowServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redFollow ${table.comment}
   * @return
   */
  @GetMapping("/redfollows" )
  public XfR getRedFollows(XfPage page, RedFollow redFollow) {
    return XfR.ok(redFollowServiceImpl.page(page, Wrappers.query(redFollow)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redfollows/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redFollowServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redFollow ${table.comment}
   * @return XfR
   */
  @PostMapping("/redfollows")
  public XfR save(@RequestBody RedFollow redFollow) {
     return XfR.ok(redFollowServiceImpl.save(redFollow));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redFollow ${table.comment}
   * @return XfR
   */
  @PutMapping("/redfollows/{id}")
  public XfR putUpdate(@RequestBody RedFollow redFollow,@PathVariable Long id) {
      redFollow.setId(id);
      return XfR.ok(redFollowServiceImpl.updateById(redFollow));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redFollow ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redfollows/{id}")
  public XfR patchUpdate(@RequestBody RedFollow redFollow,@PathVariable Long id) {
      RedFollow upredFollow = redFollowServiceImpl.getById(id);
      if(upredFollow != null){
        upredFollow = ObjectCopyUtils.copyProperties(redFollow,upredFollow,true);
      }
      return XfR.ok(redFollowServiceImpl.updateById(upredFollow));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redfollows/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redFollowServiceImpl.removeById(id));
  }

  @PostMapping("/redfollows/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_follow");
     params.put("request", condition);

     return XfR.ok(redFollowServiceImpl.querys(params));
  }

}
