package com.xforceplus.ultraman.app.oldtonewversion0510.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.oldtonewversion0510.entity.RedInformationManage;
import com.xforceplus.ultraman.app.oldtonewversion0510.service.IRedInformationManageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-11
 */
@RestController
public class RedInformationManageController {

  @Autowired
  private IRedInformationManageService redInformationManageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redInformationManage ${table.comment}
   * @return
   */
  @GetMapping("/redinformationmanages" )
  public XfR getRedInformationManages(XfPage page, RedInformationManage redInformationManage) {
    return XfR.ok(redInformationManageServiceImpl.page(page, Wrappers.query(redInformationManage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redinformationmanages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redInformationManageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redInformationManage ${table.comment}
   * @return XfR
   */
  @PostMapping("/redinformationmanages")
  public XfR save(@RequestBody RedInformationManage redInformationManage) {
     return XfR.ok(redInformationManageServiceImpl.save(redInformationManage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redInformationManage ${table.comment}
   * @return XfR
   */
  @PutMapping("/redinformationmanages/{id}")
  public XfR putUpdate(@RequestBody RedInformationManage redInformationManage,@PathVariable Long id) {
      redInformationManage.setId(id);
      return XfR.ok(redInformationManageServiceImpl.updateById(redInformationManage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redInformationManage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redinformationmanages/{id}")
  public XfR patchUpdate(@RequestBody RedInformationManage redInformationManage,@PathVariable Long id) {
      RedInformationManage upredInformationManage = redInformationManageServiceImpl.getById(id);
      if(upredInformationManage != null){
        upredInformationManage = ObjectCopyUtils.copyProperties(redInformationManage,upredInformationManage,true);
      }
      return XfR.ok(redInformationManageServiceImpl.updateById(upredInformationManage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redinformationmanages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redInformationManageServiceImpl.removeById(id));
  }

  @PostMapping("/redinformationmanages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_information_manage");
     params.put("request", condition);

     return XfR.ok(redInformationManageServiceImpl.querys(params));
  }

}
