package com.xforceplus.ultraman.app.oldtonewversion0510.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.oldtonewversion0510.entity.RedInvoiceDetail;
import com.xforceplus.ultraman.app.oldtonewversion0510.service.IRedInvoiceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 信息表与确认单共用前端控制器
 *
 * @author ultraman
 * @date 2023-05-11
 */
@RestController
public class RedInvoiceDetailController {

  @Autowired
  private IRedInvoiceDetailService redInvoiceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redInvoiceDetail 信息表与确认单共用
   * @return
   */
  @GetMapping("/redinvoicedetails" )
  public XfR getRedInvoiceDetails(XfPage page, RedInvoiceDetail redInvoiceDetail) {
    return XfR.ok(redInvoiceDetailServiceImpl.page(page, Wrappers.query(redInvoiceDetail)));
  }

  /**
   * 通过id查询信息表与确认单共用
   * @param  id
   * @return XfR
   */
  @GetMapping("/redinvoicedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redInvoiceDetailServiceImpl.getById(id));
  }

  /**
   * 新增信息表与确认单共用
   * @param redInvoiceDetail 信息表与确认单共用
   * @return XfR
   */
  @PostMapping("/redinvoicedetails")
  public XfR save(@RequestBody RedInvoiceDetail redInvoiceDetail) {
     return XfR.ok(redInvoiceDetailServiceImpl.save(redInvoiceDetail));
  }

  /**
   * 修改-传入修改后的全部数据信息表与确认单共用
   * @param redInvoiceDetail 信息表与确认单共用
   * @return XfR
   */
  @PutMapping("/redinvoicedetails/{id}")
  public XfR putUpdate(@RequestBody RedInvoiceDetail redInvoiceDetail,@PathVariable Long id) {
      redInvoiceDetail.setId(id);
      return XfR.ok(redInvoiceDetailServiceImpl.updateById(redInvoiceDetail));
  }

  /**
   * 修改-传入修改的数据信息表与确认单共用
   * @param redInvoiceDetail 信息表与确认单共用
   * @return XfR
   */
  @PatchMapping("/redinvoicedetails/{id}")
  public XfR patchUpdate(@RequestBody RedInvoiceDetail redInvoiceDetail,@PathVariable Long id) {
      RedInvoiceDetail upredInvoiceDetail = redInvoiceDetailServiceImpl.getById(id);
      if(upredInvoiceDetail != null){
        upredInvoiceDetail = ObjectCopyUtils.copyProperties(redInvoiceDetail,upredInvoiceDetail,true);
      }
      return XfR.ok(redInvoiceDetailServiceImpl.updateById(upredInvoiceDetail));
  }

  /**
   * 通过id删除信息表与确认单共用
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redinvoicedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redInvoiceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/redinvoicedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_invoice_detail");
     params.put("request", condition);

     return XfR.ok(redInvoiceDetailServiceImpl.querys(params));
  }

}
