package com.xforceplus.ultraman.app.oldtonewversion0510.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.oldtonewversion0510.entity.TaxNumberList;
import com.xforceplus.ultraman.app.oldtonewversion0510.service.ITaxNumberListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-11
 */
@RestController
public class TaxNumberListController {

  @Autowired
  private ITaxNumberListService taxNumberListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxNumberList ${table.comment}
   * @return
   */
  @GetMapping("/taxnumberlists" )
  public XfR getTaxNumberLists(XfPage page, TaxNumberList taxNumberList) {
    return XfR.ok(taxNumberListServiceImpl.page(page, Wrappers.query(taxNumberList)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxnumberlists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxNumberListServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxNumberList ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxnumberlists")
  public XfR save(@RequestBody TaxNumberList taxNumberList) {
     return XfR.ok(taxNumberListServiceImpl.save(taxNumberList));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxNumberList ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxnumberlists/{id}")
  public XfR putUpdate(@RequestBody TaxNumberList taxNumberList,@PathVariable Long id) {
      taxNumberList.setId(id);
      return XfR.ok(taxNumberListServiceImpl.updateById(taxNumberList));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxNumberList ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxnumberlists/{id}")
  public XfR patchUpdate(@RequestBody TaxNumberList taxNumberList,@PathVariable Long id) {
      TaxNumberList uptaxNumberList = taxNumberListServiceImpl.getById(id);
      if(uptaxNumberList != null){
        uptaxNumberList = ObjectCopyUtils.copyProperties(taxNumberList,uptaxNumberList,true);
      }
      return XfR.ok(taxNumberListServiceImpl.updateById(uptaxNumberList));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxnumberlists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxNumberListServiceImpl.removeById(id));
  }

  @PostMapping("/taxnumberlists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_number_list");
     params.put("request", condition);

     return XfR.ok(taxNumberListServiceImpl.querys(params));
  }

}
