package com.xforceplus.ultraman.app.oldtonewversion0510.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.oldtonewversion0510.entity.WorkflowOperateManage;
import com.xforceplus.ultraman.app.oldtonewversion0510.service.IWorkflowOperateManageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-11
 */
@RestController
public class WorkflowOperateManageController {

  @Autowired
  private IWorkflowOperateManageService workflowOperateManageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param workflowOperateManage ${table.comment}
   * @return
   */
  @GetMapping("/workflowoperatemanages" )
  public XfR getWorkflowOperateManages(XfPage page, WorkflowOperateManage workflowOperateManage) {
    return XfR.ok(workflowOperateManageServiceImpl.page(page, Wrappers.query(workflowOperateManage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/workflowoperatemanages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(workflowOperateManageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param workflowOperateManage ${table.comment}
   * @return XfR
   */
  @PostMapping("/workflowoperatemanages")
  public XfR save(@RequestBody WorkflowOperateManage workflowOperateManage) {
     return XfR.ok(workflowOperateManageServiceImpl.save(workflowOperateManage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param workflowOperateManage ${table.comment}
   * @return XfR
   */
  @PutMapping("/workflowoperatemanages/{id}")
  public XfR putUpdate(@RequestBody WorkflowOperateManage workflowOperateManage,@PathVariable Long id) {
      workflowOperateManage.setId(id);
      return XfR.ok(workflowOperateManageServiceImpl.updateById(workflowOperateManage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param workflowOperateManage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/workflowoperatemanages/{id}")
  public XfR patchUpdate(@RequestBody WorkflowOperateManage workflowOperateManage,@PathVariable Long id) {
      WorkflowOperateManage upworkflowOperateManage = workflowOperateManageServiceImpl.getById(id);
      if(upworkflowOperateManage != null){
        upworkflowOperateManage = ObjectCopyUtils.copyProperties(workflowOperateManage,upworkflowOperateManage,true);
      }
      return XfR.ok(workflowOperateManageServiceImpl.updateById(upworkflowOperateManage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/workflowoperatemanages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(workflowOperateManageServiceImpl.removeById(id));
  }

  @PostMapping("/workflowoperatemanages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "workflow_operate_manage");
     params.put("request", condition);

     return XfR.ok(workflowOperateManageServiceImpl.querys(params));
  }

}
