package com.xforceplus.ultraman.app.openapirapi.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-07-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.KnowledgeList;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "openapi-rapi")
public interface KnowledgeListFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/knowledgeList/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param knowledgeList ${table.comment}
   * @return R
   */
  @PostMapping("/knowledgeList/add")
  public R save(@RequestBody KnowledgeList knowledgeList);

  /**
   * 修改${table.comment}
   * @param knowledgeList ${table.comment}
   * @return R
   */
  @PostMapping("/knowledgeList/update")
  public R updateById(@RequestBody KnowledgeList knowledgeList);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/knowledgeList/del/{id}" )
  public R removeById(@PathVariable Long id);

}