package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 认证方式
 * </p>
 *
 * @author ultraman
 * @since 2023-01-12
 */
public enum AuthStyle {

    _0("0", "默认"),
    _10("10", "平台页面勾选"),
    _11("11", "平台接口勾选"),
    _12("12", "国税底账勾选");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthStyle(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStyle fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            default:
                return null;
        }
    }
}
