package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票来源
 * </p>
 *
 * @author ultraman
 * @since 2023-02-08
 */
public enum DataSource {

    SALES_V4("SALES_V4", "4.0 销项"),
    PURCHASE_V4("PURCHASE_V4", "4.0 进项"),
    SALES_V3("SALES_V3", "3.0 销项"),
    PURCHASE_V3("PURCHASE_V3", "3.0 进项"),
    TAXWARE_LF("TAXWARE_LF", "税件发票低频"),
    TAXWARE_CO("TAXWARE_CO", "税件发票归集"),
    IMAGE("IMAGE", "电子影像");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DataSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataSource fromCode(String code){
        switch(code) {
            case "SALES_V4":
                return SALES_V4;
            case "PURCHASE_V4":
                return PURCHASE_V4;
            case "SALES_V3":
                return SALES_V3;
            case "PURCHASE_V3":
                return PURCHASE_V3;
            case "TAXWARE_LF":
                return TAXWARE_LF;
            case "TAXWARE_CO":
                return TAXWARE_CO;
            case "IMAGE":
                return IMAGE;
            default:
                return null;
        }
    }
}
