package com.xforceplus.ultraman.app.openapirapi.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-02-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceSendStatistic implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 租户代码
   */
  @TableField("tenantCode")
  private String tenantCode;

  /**
   * 账户类型
   */
  @TableField("accountType")
  private String accountType;

  /**
   * 年份
   */
  private String year;

  /**
   * 月份
   */
  private String month;

  /**
   * 税号
   */
  @TableField("taxNo")
  private String taxNo;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 发送发票数量
   */
  @TableField("sendNum")
  private String sendNum;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 税件低频统计
   */
  @TableField("numberFromTaxwareLR")
  private String numberFromTaxwareLR;

  /**
   * 税件归集统计
   */
  @TableField("numberFromTaxwareCO")
  private String numberFromTaxwareCO;

  /**
   * 4.0 进项统计局
   */
  @TableField("numberFromPurchaseV4")
  private String numberFromPurchaseV4;

  /**
   * 4.0 销项统计
   */
  @TableField("numberFromSalesV4")
  private String numberFromSalesV4;

  /**
   * 电子影像统计
   */
  @TableField("numberFromImage")
  private String numberFromImage;

  /**
   * 集成平台统计
   */
  @TableField("numberFromIP")
  private String numberFromIP;

  /**
   * 发送统计是否匹配
   */
  @TableField("matchFlag")
  private Boolean matchFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tenantCode", tenantCode);
      map.put("accountType", accountType);
      map.put("year", year);
      map.put("month", month);
      map.put("taxNo", taxNo);
      map.put("invoiceType", invoiceType);
      map.put("sendNum", sendNum);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("numberFromTaxwareLR", numberFromTaxwareLR);
      map.put("numberFromTaxwareCO", numberFromTaxwareCO);
      map.put("numberFromPurchaseV4", numberFromPurchaseV4);
      map.put("numberFromSalesV4", numberFromSalesV4);
      map.put("numberFromImage", numberFromImage);
      map.put("numberFromIP", numberFromIP);
      map.put("matchFlag", matchFlag);
      return map;
  }

  public static InvoiceSendStatistic fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceSendStatistic entity = new InvoiceSendStatistic();
    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String){
          entity.setYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("month")) {
      Object obj = map.get("month");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNum")) {
      Object obj = map.get("sendNum");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSendNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromTaxwareLR")) {
      Object obj = map.get("numberFromTaxwareLR");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNumberFromTaxwareLR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromTaxwareCO")) {
      Object obj = map.get("numberFromTaxwareCO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNumberFromTaxwareCO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromPurchaseV4")) {
      Object obj = map.get("numberFromPurchaseV4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNumberFromPurchaseV4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromSalesV4")) {
      Object obj = map.get("numberFromSalesV4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNumberFromSalesV4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromImage")) {
      Object obj = map.get("numberFromImage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNumberFromImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromIP")) {
      Object obj = map.get("numberFromIP");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNumberFromIP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchFlag")) {
      Object obj = map.get("matchFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setMatchFlag((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setMatchFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("month")) {
      Object obj = map.get("month");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMonth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sendNum")) {
      Object obj = map.get("sendNum");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSendNum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("numberFromTaxwareLR")) {
      Object obj = map.get("numberFromTaxwareLR");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNumberFromTaxwareLR((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("numberFromTaxwareCO")) {
      Object obj = map.get("numberFromTaxwareCO");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNumberFromTaxwareCO((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("numberFromPurchaseV4")) {
      Object obj = map.get("numberFromPurchaseV4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNumberFromPurchaseV4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("numberFromSalesV4")) {
      Object obj = map.get("numberFromSalesV4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNumberFromSalesV4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("numberFromImage")) {
      Object obj = map.get("numberFromImage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNumberFromImage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("numberFromIP")) {
      Object obj = map.get("numberFromIP");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNumberFromIP((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("matchFlag")) {
      Object obj = map.get("matchFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setMatchFlag((Boolean)obj);
        } else if(obj instanceof String) {
          this.setMatchFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
  }
}
