package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 国税发票来源
 * </p>
 *
 * @author ultraman
 * @since 2023-03-03
 */
public enum TaxInvoiceSource {

    SK("sk", "税控"),
    QD("qd", "全电");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxInvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSource fromCode(String code){
        switch(code) {
            case "sk":
                return SK;
            case "qd":
                return QD;
            default:
                return null;
        }
    }
}
