package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public enum ImageInvoiceType {

    T("t", "火车票"),
    TAXI("taxi", "出租车票"),
    QUOTA("quota", "定额发票"),
    VS("vs", "二手车发票"),
    IM("im", "通用机打发票"),
    TOLL("toll", "过路费发票"),
    P("p", "飞机票"),
    BUS("bus", "客运公交票"),
    OTHER("other", "其他发票"),
    CT("ct", "增值税电子普通发票（通行费) "),
    PAYMENT("payment", "海关缴款书"),
    CDF("cdf", "海关货物报关单"),
    FC("fc", "财政票据"),
    FCE("fce", "通用财政票据（电子）"),
    MOE("moe", "医疗门诊收费票据（电子）"),
    MHE("mhe", "医疗住院收费票据（电子）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ImageInvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageInvoiceType fromCode(String code){
        switch(code) {
            case "t":
                return T;
            case "taxi":
                return TAXI;
            case "quota":
                return QUOTA;
            case "vs":
                return VS;
            case "im":
                return IM;
            case "toll":
                return TOLL;
            case "p":
                return P;
            case "bus":
                return BUS;
            case "other":
                return OTHER;
            case "ct":
                return CT;
            case "payment":
                return PAYMENT;
            case "cdf":
                return CDF;
            case "fc":
                return FC;
            case "fce":
                return FCE;
            case "moe":
                return MOE;
            case "mhe":
                return MHE;
            default:
                return null;
        }
    }
}
