package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 事件类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-13
 */
public enum EventType {

    TAXWARE_INVOICE_SYNC_EVENT("taxware-invoice-sync-event", "进销项发票低频同步"),
    TAXWARE_INVOICE_COLLECTION_SYNC_EVENT("taxware-invoice-collection-sync-event", "发票归集同步");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EventType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EventType fromCode(String code){
        switch(code) {
            case "taxware-invoice-sync-event":
                return TAXWARE_INVOICE_SYNC_EVENT;
            case "taxware-invoice-collection-sync-event":
                return TAXWARE_INVOICE_COLLECTION_SYNC_EVENT;
            default:
                return null;
        }
    }
}
