package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 抵扣用途
 * </p>
 *
 * @author ultraman
 * @since 2023-08-04
 */
public enum AuthUse {

    _1("1", "抵扣"),
    _2("2", "不抵扣"),
    _3("3", "退税"),
    _4("4", "代办退税");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthUse(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthUse fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
